/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.server.Bootstrap;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamUtils {
    private static final Logger LOGGER = LogManager.getLogger(StreamUtils.class);
    private static final AtomicInteger POOL_THREAD_COUNTER = new AtomicInteger();
    private static ForkJoinPool POOL = null;

    public static void setup(Object classCtx) {
        ClassLoader classLoader = classCtx.getClass().getClassLoader();
        POOL = new ForkJoinPool(Math.max(4, Runtime.getRuntime().availableProcessors() - 4), forkJoinPool -> {
            ForkJoinWorkerThread thread = new ForkJoinWorkerThread(forkJoinPool){};
            thread.setContextClassLoader(classLoader);
            thread.setName(String.format("FastSuite Recipe Lookup Thread: %s", POOL_THREAD_COUNTER.incrementAndGet()));
            return thread;
        }, StreamUtils::onThreadException, true);
    }

    private static void onThreadException(Thread thread, Throwable cause) {
        if (cause instanceof CompletionException) {
            cause = cause.getCause();
        }
        if (cause instanceof ReportedException) {
            Bootstrap.m_135875_((String)((ReportedException)cause).m_134761_().m_127526_());
            System.exit(-1);
        }
        LOGGER.error(String.format("Caught exception in thread %s", thread), cause);
    }

    public static void execute(Runnable runnable) {
        if (POOL == null) {
            throw new IllegalStateException("Tried to run a task in parallel before FastSuite has been initialized!");
        }
        POOL.invoke(new RunnableExecuteAction(runnable));
    }

    public static <T> T execute(Callable<T> callable) {
        if (POOL == null) {
            throw new IllegalStateException("Tried to run a task in parallel before FastSuite has been initialized!");
        }
        return POOL.invoke(new CallableExecuteAction<T>(callable));
    }

    public static <T> T executeUntil(Callable<T> callable, long maxTime, TimeUnit unit, T fallback, Supplier<String> timeoutMsg) {
        if (POOL == null) {
            throw new IllegalStateException("Tried to run a task in parallel before FastSuite has been initialized!");
        }
        ForkJoinTask<T> task = POOL.submit(new CallableExecuteAction<T>(callable));
        try {
            return task.get(maxTime, unit);
        }
        catch (InterruptedException | TimeoutException ex) {
            System.out.println(timeoutMsg.get());
            ex.printStackTrace();
            StreamUtils.dumpFSThreads();
            return fallback;
        }
        catch (ExecutionException e) {
            System.out.println("Exception during multithreaded recipe lookup");
            e.printStackTrace();
            throw new RuntimeException(e.getCause());
        }
    }

    public static void dumpFSThreads() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
        System.out.println(Arrays.stream(infos).filter(info -> info.getThreadName().startsWith("FastSuite")).map(Object::toString).collect(Collectors.joining()));
    }

    public static <M> CompletableFuture<M> supplyAsync(Supplier<M> supplier) {
        return CompletableFuture.supplyAsync(supplier, POOL);
    }

    private static final class RunnableExecuteAction
    extends ForkJoinTask<Void> {
        final Runnable runnable;

        private RunnableExecuteAction(Runnable runnable) {
            Validate.notNull((Object)runnable);
            this.runnable = runnable;
        }

        @Override
        public Void getRawResult() {
            return null;
        }

        @Override
        public void setRawResult(Void v) {
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            return true;
        }
    }

    private static final class CallableExecuteAction<T>
    extends ForkJoinTask<T> {
        final Callable<T> callable;
        T rawResult;

        private CallableExecuteAction(Callable<T> callable) {
            Validate.notNull(callable);
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.rawResult;
        }

        @Override
        public void setRawResult(T v) {
            this.rawResult = v;
        }

        @Override
        public boolean exec() {
            try {
                this.setRawResult(this.callable.call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }
}

