/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.block.AfterMoveCollidableBlock;
import org.dimdev.dimdoors.api.block.ExplosionConvertibleBlock;
import org.dimdev.dimdoors.api.entity.LastPositionProvider;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;
import org.dimdev.dimdoors.block.CoordinateTransformerBlock;
import org.dimdev.dimdoors.block.DimensionalPortalBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class DimensionalDoorBlock
extends WaterLoggableDoorBlock
implements RiftProvider<EntranceRiftBlockEntity>,
CoordinateTransformerBlock,
ExplosionConvertibleBlock,
AfterMoveCollidableBlock {
    public DimensionalDoorBlock(BlockBehaviour.Properties settings, BlockSetType blockSetType) {
        super(settings.m_278166_(PushReaction.BLOCK), blockSetType);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.f_46443_ || entity instanceof ServerPlayer) {
            return;
        }
        this.onCollision(state, world, pos, entity, entity.m_20182_().m_82546_(((LastPositionProvider)entity).getLastPos()));
    }

    @Override
    public InteractionResult onAfterMovePlayerCollision(BlockState state, ServerLevel world, BlockPos pos, ServerPlayer player, Vec3 positionChange) {
        return this.onCollision(state, (Level)world, pos, (Entity)player, positionChange);
    }

    private InteractionResult onCollision(BlockState state, Level world, BlockPos pos, Entity entity, Vec3 positionChange) {
        BlockPos top = state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? pos : pos.m_7494_();
        BlockPos bottom = top.m_7495_();
        BlockState doorState = world.m_8055_(bottom);
        if (doorState.m_60734_() != this || !((Boolean)doorState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            return InteractionResult.PASS;
        }
        Vec3 currentPos = entity.m_20182_();
        Vec3 previousPos = currentPos.m_82546_(positionChange);
        double portalHalfWidth = 0.5;
        double portalHeight = 2.0;
        double portalOffsetFromCenter = 0.31;
        Vec3 portalNormal = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)f_52726_)).m_122424_().m_122436_());
        Vec3 origin = Vec3.m_82539_((Vec3i)bottom);
        Vec3 bottomMiddlePortalPoint = origin.m_82549_(portalNormal.m_82490_(portalOffsetFromCenter));
        double dotCurrent = portalNormal.m_82526_(currentPos.m_82546_(bottomMiddlePortalPoint));
        double dotPrevious = portalNormal.m_82526_(previousPos.m_82546_(bottomMiddlePortalPoint));
        if (!((dotCurrent <= 0.0 && dotPrevious >= 0.0 || dotCurrent >= 0.0 && dotPrevious <= 0.0) && (dotCurrent != 0.0 || dotPrevious != 0.0))) {
            return InteractionResult.PASS;
        }
        Vec3 yVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 xzVec = portalNormal.m_82537_(yVec);
        Vec3 vecFromPreviousPosToPortalPlane = bottomMiddlePortalPoint.m_82546_(previousPos);
        Vec3 normalizedPositionChange = positionChange.m_82541_();
        Vec3 pointOfIntersection = previousPos.m_82549_(normalizedPositionChange.m_82490_(vecFromPreviousPosToPortalPlane.m_82526_(normalizedPositionChange) / normalizedPositionChange.m_82526_(normalizedPositionChange)));
        Vec3 intersectionRelativeToPortalPlane = pointOfIntersection.m_82546_(bottomMiddlePortalPoint);
        double relativeIntersectionHeight = intersectionRelativeToPortalPlane.m_82526_(yVec);
        double relativeIntersectionWidth = intersectionRelativeToPortalPlane.m_82526_(xzVec);
        if (relativeIntersectionHeight < 0.0 || relativeIntersectionHeight > portalHeight || Math.abs(relativeIntersectionWidth) > portalHalfWidth) {
            return InteractionResult.PASS;
        }
        if (entity.m_20092_()) {
            entity.m_20091_();
            return InteractionResult.PASS;
        }
        entity.m_20091_();
        this.getRift(world, pos, state).teleport(entity);
        if (DimensionalDoors.getConfig().getDoorsConfig().closeDoorBehind) {
            world.m_46597_(top, (BlockState)world.m_8055_(top).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)));
            world.m_46597_(bottom, (BlockState)world.m_8055_(bottom).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        state = (BlockState)state.m_61122_((Property)f_52727_);
        world.m_7731_(pos, state, 10);
        if (!world.f_46443_ && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        this.m_245755_((Entity)player, world, pos, (Boolean)state.m_61143_((Property)f_52727_));
        world.m_142346_((Entity)player, this.m_52815_(state) ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.SUCCESS;
    }

    public void m_213646_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EntranceRiftBlockEntity) {
            EntranceRiftBlockEntity blockEntity2 = (EntranceRiftBlockEntity)blockEntity;
            level.m_7654_().m_18707_(() -> blockEntity2.generateDetached((Level)level));
        }
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        return super.m_6864_(blockState, blockPlaceContext) || blockState.m_60734_() == ModBlocks.DETACHED_RIFT.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            return null;
        }
        return new EntranceRiftBlockEntity(pos, state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            return Collections.emptyList();
        }
        return super.m_49635_(state, params);
    }

    public void createDetachedRift(Level world, BlockPos pos, BlockState state) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        BlockPos blockPos = pos;
        BlockState blockState = world.m_8055_(pos);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER) {
            blockPos = pos.m_7495_();
            blockState = world.m_8055_(blockPos);
            blockEntity = world.m_7702_(blockPos);
        }
        if (blockEntity instanceof EntranceRiftBlockEntity && blockState.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER) {
            world.m_46597_(blockPos, (BlockState)((Block)ModBlocks.DETACHED_RIFT.get()).m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WATERLOGGED))));
            ((DetachedRiftBlockEntity)world.m_7702_(blockPos)).setData(((EntranceRiftBlockEntity)blockEntity).getData());
        }
    }

    public void m_7592_(Level world, BlockPos pos, Explosion explosion) {
        if (world.m_8055_(pos).m_60795_()) {
            return;
        }
        if (world.m_5776_()) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        super.m_7592_(world, pos, explosion);
    }

    @Override
    public EntranceRiftBlockEntity getRift(Level world, BlockPos pos, BlockState state) {
        BlockEntity topEntity;
        BlockEntity bottomEntity;
        if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            bottomEntity = world.m_7702_(pos);
            topEntity = world.m_7702_(pos.m_7494_());
        } else {
            bottomEntity = world.m_7702_(pos.m_7495_());
            topEntity = world.m_7702_(pos);
        }
        if (bottomEntity instanceof EntranceRiftBlockEntity && topEntity instanceof EntranceRiftBlockEntity) {
            f_49790_.warn("Dimensional door at " + String.valueOf(pos) + " in world " + String.valueOf(world) + " contained two rifts, please report this. Defaulting to bottom.");
            return (EntranceRiftBlockEntity)bottomEntity;
        }
        if (bottomEntity instanceof EntranceRiftBlockEntity) {
            return (EntranceRiftBlockEntity)bottomEntity;
        }
        if (topEntity instanceof EntranceRiftBlockEntity) {
            return (EntranceRiftBlockEntity)topEntity;
        }
        throw new IllegalStateException("Dimensional door at " + String.valueOf(pos) + " in world " + String.valueOf(world) + " contained no rift.");
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        if (half == DoubleBlockHalf.LOWER) {
            this.createDetachedRift(world, pos, state);
        }
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        super.m_6786_(level, pos, state);
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83144_();
    }

    @Override
    public TransformationMatrix3d.TransformationMatrix3dBuilder transformationBuilder(BlockState state, BlockPos pos) {
        return TransformationMatrix3d.builder().inverseTranslate(Vec3.m_82512_((Vec3i)pos).m_82549_(Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122436_()).m_82490_(-0.31))).inverseRotate(MathUtil.directionEulerAngle(((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122424_()));
    }

    @Override
    public TransformationMatrix3d.TransformationMatrix3dBuilder rotatorBuilder(BlockState state, BlockPos pos) {
        return TransformationMatrix3d.builder().inverseRotate(MathUtil.directionEulerAngle(((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122424_()));
    }

    @Override
    public boolean isExitFlipped() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isTall(BlockState cachedState) {
        return true;
    }

    @Override
    public InteractionResult explode(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        this.createDetachedRift(world, pos, state);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return DimensionalPortalBlock.Dummy.checkType(type, (BlockEntityType)ModBlockEntityTypes.ENTRANCE_RIFT.get(), (level, blockPos, blockState, blockEntity) -> blockEntity.tick(world, blockPos, blockState));
    }

    public Block baseBlock() {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(DimensionalDoors.getDimensionalDoorBlockRegistrar().get(BuiltInRegistries.f_256975_.m_7981_((Object)this)));
    }
}

