/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.DetachedRiftBlock;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.RiftCurves;
import org.dimdev.dimdoors.world.decay.Decay;
import org.dimdev.dimdoors.world.decay.DecaySource;

public class DetachedRiftBlockEntity
extends RiftBlockEntity<DetachedRiftBlock> {
    private static final int UPDATE_PERIOD = 200;
    private static final RandomSource random = RandomSource.m_216327_();
    public int spawnedEndermanId = 0;
    public float riftYaw;
    public int curveID = (int)(Math.random() * (double)RiftCurves.CURVES.size());
    private boolean unregisterDisabled = false;
    @OnlyIn(value=Dist.CLIENT)
    public double renderAngle;

    public DetachedRiftBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends RiftBlockEntity>)((BlockEntityType)ModBlockEntityTypes.DETACHED_RIFT.get()), pos, state);
        this.riftYaw = random.m_188503_(360);
    }

    @Override
    protected Class<DetachedRiftBlock> blockClass() {
        return DetachedRiftBlock.class;
    }

    public void applySpreadDecay(ServerLevel world, BlockPos pos) {
        float chance = this.size / 100.0f;
        if (random.m_188501_() <= chance) {
            BlockPos selected = (BlockPos)BlockPos.m_235650_((RandomSource)world.m_213780_(), (int)1, (BlockPos)pos, (int)((int)chance)).iterator().next();
            Decay.decayBlock(world, selected, world.m_8055_(selected), DecaySource.RIFT);
        }
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        this.m_6596_();
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.m_6596_();
    }

    public int getCurveID() {
        return this.curveID;
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        super.serialize(nbt);
        nbt.m_128405_("spawnedEnderManId", this.spawnedEndermanId);
        nbt.m_128405_("curveID", this.curveID);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.spawnedEndermanId = nbt.m_128451_("spawnedEnderManId");
        this.curveID = nbt.m_128451_("curveID");
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public void unregister() {
        if (!this.unregisterDisabled) {
            super.unregister();
        }
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 velocity, Location location) {
        if (this.f_58857_ instanceof ServerLevel) {
            TeleportUtil.teleport(entity, this.f_58857_, this.f_58858_, relativeAngle, velocity);
        }
        return true;
    }

    public void setUnregisterDisabled(boolean unregisterDisabled) {
        this.unregisterDisabled = unregisterDisabled;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128350_("size", this.size);
        tag.m_128405_("curveID", this.curveID);
        return tag;
    }

    @Override
    protected void onClose(Level level, BlockPos pos) {
        level.m_7471_(pos, false);
    }

    @Override
    protected void onUpdate(Level level, BlockPos pos) {
        List list;
        if (level.f_46443_) {
            return;
        }
        if (level.m_6815_(this.spawnedEndermanId) instanceof EnderMan) {
            return;
        }
        if ((double)random.m_188501_() < DimensionalDoors.getConfig().getGeneralConfig().endermanSpawnChance && this.updateNearestRift() && (list = level.m_45976_(EnderMan.class, new AABB((double)(pos.m_123341_() - 9), (double)(pos.m_123342_() - 3), (double)(pos.m_123343_() - 9), (double)(pos.m_123341_() + 9), (double)(pos.m_123342_() + 3), (double)(pos.m_123343_() + 9)))).isEmpty()) {
            Player player;
            EnderMan enderman = (EnderMan)EntityType.f_20566_.m_262496_((ServerLevel)level, pos, MobSpawnType.STRUCTURE);
            enderman.m_19890_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() - 1), (double)pos.m_123343_() + 0.5, 5.0f, 6.0f);
            if (random.m_188500_() < DimensionalDoors.getConfig().getGeneralConfig().endermanAggressiveChance && (player = level.m_45930_((Entity)enderman, 50.0)) != null) {
                enderman.m_6710_((LivingEntity)player);
            }
        }
    }

    @Override
    public void onGrowth(Level level, BlockPos pos) {
        for (int n = 0; n < 10; ++n) {
            this.size = (float)((double)this.size + DimensionalDoors.getConfig().getGeneralConfig().riftGrowthSpeed / (double)(this.size + 1.0f));
        }
        if (!level.m_5776_() && DimensionalDoors.getConfig().getGeneralConfig().enableRiftDecay) {
            this.applySpreadDecay((ServerLevel)level, pos);
        }
    }
}

