/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;
import org.dimdev.dimdoors.block.CoordinateTransformerBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.Rift;
import org.dimdev.dimdoors.rift.targets.LocationProvider;
import org.dimdev.dimdoors.rift.targets.MessageTarget;
import org.dimdev.dimdoors.rift.targets.Targets;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.jetbrains.annotations.NotNull;

public abstract class RiftBlockEntity<T extends Block>
extends BlockEntity
implements Target,
EntityTarget {
    private static final int UPDATE_PERIOD = 200;
    private static final RandomSource random = RandomSource.m_216327_();
    private static final Logger LOGGER = LogManager.getLogger();
    public static long showRiftCoreUntil = 0L;
    @NotNull
    protected RiftData data = new RiftData();
    public float size = 0.0f;
    private int updateTimer = random.m_188503_(200);
    public boolean closing;
    public boolean stabilized;
    protected boolean riftStateChanged;

    public RiftBlockEntity(BlockEntityType<? extends RiftBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.deserialize(nbt);
    }

    public void deserialize(CompoundTag nbt) {
        this.data = RiftData.fromNbt(nbt.m_128469_("data"));
        this.closing = nbt.m_128471_("closing");
        this.stabilized = nbt.m_128471_("stablized");
        this.size = nbt.m_128457_("size");
        this.updateTimer = nbt.m_128451_("updateTimer");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.serialize(nbt);
    }

    public CompoundTag serialize(CompoundTag nbt) {
        nbt.m_128365_("data", (Tag)RiftData.toNbt(this.data));
        nbt.m_128379_("closing", this.closing);
        nbt.m_128379_("stablized", this.stabilized);
        nbt.m_128350_("size", this.size);
        nbt.m_128405_("updateTimer", this.updateTimer);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void setDestination(VirtualTarget destination) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting destination {} for {}", (Object)destination, (Object)this.f_58858_.m_123344_());
        }
        if (this.getDestination() != null && this.isRegistered()) {
            this.getDestination().unregister();
        }
        this.data.setDestination(destination);
        if (destination != null) {
            if (this.f_58857_ != null && this.f_58858_ != null) {
                destination.setLocation(new Location((ServerLevel)this.f_58857_, this.f_58858_));
            }
            if (this.isRegistered()) {
                destination.register();
            }
        }
        this.riftStateChanged = true;
        this.m_6596_();
        this.updateColor();
    }

    public void setColor(RGBA color) {
        this.data.setColor(color);
        this.m_6596_();
    }

    public void setProperties(LinkProperties properties) {
        this.data.setProperties(properties);
        this.updateProperties();
        this.m_6596_();
    }

    public CompoundTag m_5995_() {
        return super.m_5995_();
    }

    public void markStateChanged() {
        this.riftStateChanged = true;
        this.m_6596_();
    }

    public boolean isRegistered() {
        return this.f_58857_ != null && DimensionalRegistry.getRiftRegistry().isRiftAt(new Location((ServerLevel)this.f_58857_, this.f_58858_));
    }

    public void register() {
        if (this.isRegistered()) {
            return;
        }
        Location loc = new Location((ServerLevel)this.f_58857_, this.f_58858_);
        DimensionalRegistry.getRiftRegistry().addRift(loc);
        if (this.data.getDestination() != VirtualTarget.NoneTarget.INSTANCE) {
            this.data.getDestination().register();
        }
        this.updateProperties();
        this.updateColor();
    }

    public void updateProperties() {
        if (this.isRegistered()) {
            DimensionalRegistry.getRiftRegistry().setProperties(new Location((ServerLevel)this.f_58857_, this.f_58858_), this.data.getProperties());
        }
        this.m_6596_();
    }

    public void unregister() {
        if (this.isRegistered()) {
            DimensionalRegistry.getRiftRegistry().removeRift(new Location((ServerLevel)this.f_58857_, this.f_58858_));
        }
    }

    public void updateType() {
        if (!this.isRegistered()) {
            return;
        }
        Rift rift = DimensionalRegistry.getRiftRegistry().getRift(new Location((ServerLevel)this.f_58857_, this.f_58858_));
        rift.setDetached(this.isDetached());
        rift.markDirty();
    }

    public void handleTargetGone(Location location) {
        if (this.data.getDestination().shouldInvalidate(location)) {
            this.data.setDestination(VirtualTarget.NoneTarget.INSTANCE);
            this.m_6596_();
        }
        this.updateColor();
    }

    public void handleSourceGone(Location location) {
        this.updateColor();
    }

    public Target getTarget() {
        if (this.data.getDestination() == VirtualTarget.NoneTarget.INSTANCE) {
            return new MessageTarget("rifts.unlinked1", new Object[0]);
        }
        this.data.getDestination().setLocation(new Location((ServerLevel)this.f_58857_, this.f_58858_));
        return this.data.getDestination();
    }

    public boolean teleport(Entity entity) {
        this.riftStateChanged = false;
        try {
            Location location;
            Vec3 relativePos = new Vec3(0.0, 0.0, 0.0);
            Rotations relativeAngle = new Rotations(entity.m_146909_(), entity.m_146908_(), 0.0f);
            Vec3 relativeVelocity = entity.m_20184_();
            Target target = this.getTarget();
            if (target instanceof LocationProvider) {
                LocationProvider provider = (LocationProvider)((Object)target);
                location = provider.getLocation();
            } else {
                location = null;
            }
            Location location2 = location;
            EntityTarget target2 = this.getTarget().as(Targets.ENTITY);
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            Block block = state.m_60734_();
            if (block instanceof CoordinateTransformerBlock) {
                CoordinateTransformerBlock transformer = (CoordinateTransformerBlock)block;
                TransformationMatrix3d.TransformationMatrix3dBuilder transformationBuilder = transformer.transformationBuilder(state, this.m_58899_());
                TransformationMatrix3d.TransformationMatrix3dBuilder rotatorBuilder = transformer.rotatorBuilder(state, this.m_58899_());
                relativePos = transformer.transformTo(transformationBuilder, entity.m_20182_());
                relativeAngle = transformer.rotateTo(rotatorBuilder, relativeAngle);
                relativeVelocity = transformer.rotateTo(rotatorBuilder, relativeVelocity);
            }
            if (target2.receiveEntity(entity, relativePos, relativeAngle, relativeVelocity, location2)) {
                VirtualLocation vLoc = VirtualLocation.fromLocation(new Location((ServerLevel)entity.m_9236_(), entity.m_20183_()));
                if (DimensionalDoors.getConfig().getGeneralConfig().enableDebugMessages) {
                    EntityUtils.chat(entity, (Component)Component.m_237113_((String)("You are at x = " + vLoc.getX() + ", y = ?, z = " + vLoc.getZ() + ", w = " + vLoc.getDepth())));
                }
                return true;
            }
        }
        catch (Exception e) {
            EntityUtils.chat(entity, (Component)Component.m_237113_((String)"Something went wrong while trying to teleport you, please report this bug."));
            LOGGER.error("Teleporting failed with the following exception: ", (Throwable)e);
        }
        return false;
    }

    public void updateColor() {
        if (this.data.isForcedColor()) {
            return;
        }
        if (!this.isRegistered()) {
            this.data.setColor(new RGBA(0.0f, 0.0f, 0.0f, 1.0f));
        } else if (this.data.getDestination() == VirtualTarget.NoneTarget.INSTANCE) {
            this.data.setColor(new RGBA(0.7f, 0.7f, 0.7f, 1.0f));
        } else {
            this.data.getDestination().setLocation(new Location((ServerLevel)this.f_58857_, this.f_58858_));
            RGBA newColor = this.data.getDestination().getColor();
            if (this.data.getColor() == null && newColor != null || !Objects.equals(this.data.getColor(), newColor)) {
                this.data.setColor(newColor);
                this.m_6596_();
            }
        }
    }

    public abstract boolean isDetached();

    public abstract void setLocked(boolean var1);

    public abstract boolean isLocked();

    public void copyFrom(DetachedRiftBlockEntity rift) {
        this.data.setDestination(rift.data.getDestination());
        this.data.setProperties(rift.data.getProperties());
        this.data.setAlwaysDelete(rift.data.isAlwaysDelete());
        this.data.setForcedColor(rift.data.isForcedColor());
    }

    public VirtualTarget getDestination() {
        return this.data.getDestination();
    }

    public LinkProperties getProperties() {
        return this.data.getProperties();
    }

    public boolean isAlwaysDelete() {
        return this.data.isAlwaysDelete();
    }

    public boolean isForcedColor() {
        return this.data.isForcedColor();
    }

    public RGBA getColor() {
        return this.data.getColor();
    }

    public void setData(RiftData data) {
        this.data = data;
    }

    public RiftData getData() {
        return this.data;
    }

    public void setWorld(Level level) {
        this.f_58857_ = level;
    }

    public Rift asRift() {
        return DimensionalRegistry.getRiftRegistry().getRift(new Location((ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_));
    }

    public void tick(Level level, BlockPos pos, BlockState blockState) {
        if (level.f_46443_) {
            return;
        }
        if (this.updateTimer >= 200) {
            this.onUpdate(level, pos);
            this.updateTimer = 0;
        }
        ++this.updateTimer;
        if (this.closing) {
            if (this.size > 0.0f) {
                this.size = (float)((double)this.size - DimensionalDoors.getConfig().getGeneralConfig().riftCloseSpeed);
            } else {
                this.onClose(level, pos);
            }
        } else if (!this.stablized()) {
            this.onGrowth(level, pos);
        }
        this.m_6596_();
    }

    public void onGrowth(Level level, BlockPos pos) {
    }

    public boolean stablized() {
        return this.stabilized;
    }

    protected void onClose(Level level, BlockPos pos) {
    }

    protected void onUpdateHalfway(Level level, BlockPos pos) {
    }

    protected void onUpdate(Level level, BlockPos pos) {
    }

    protected abstract Class<T> blockClass();

    public boolean updateNearestRift() {
        return false;
    }
}

