/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.ModConfig;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.client.DetachedRiftBlockEntityRenderer;
import org.dimdev.dimdoors.client.EntranceRiftBlockEntityRenderer;
import org.dimdev.dimdoors.client.ModShaders;
import org.dimdev.dimdoors.client.MonolithRenderer;
import org.dimdev.dimdoors.client.ShaderPackDetector;
import org.dimdev.dimdoors.client.screen.TesselatingLoomScreen;
import org.dimdev.dimdoors.compat.iris.IrisCompat;
import org.dimdev.dimdoors.entity.MaskEntity;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.item.RaycastHelper;
import org.dimdev.dimdoors.network.client.ClientPacketHandler;
import org.dimdev.dimdoors.network.packet.c2s.NetworkHandlerInitializedC2SPacket;
import org.dimdev.dimdoors.particle.ModParticleTypes;
import org.dimdev.dimdoors.particle.client.LimboAshParticle;
import org.dimdev.dimdoors.particle.client.MonolithParticle;
import org.dimdev.dimdoors.particle.client.RiftParticle;
import org.dimdev.dimdoors.screen.ModScreenHandlerTypes;

@OnlyIn(value=Dist.CLIENT)
public class DimensionalDoorsClient {
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();
    public static final ResourceLocation childItem = DimensionalDoors.id("item/child_item");
    public static ShaderPackDetector detector = () -> false;

    public static void init() {
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(handler -> ClientPacketHandler.sendPacket(new NetworkHandlerInitializedC2SPacket()));
        ClientGuiEvent.DEBUG_TEXT_LEFT.register((Object)new ClientGuiEvent.DebugText(){

            public void gatherText(List<String> strings) {
                BlockEntity blockEntity;
                assert (Minecraft.m_91087_().f_91074_ != null);
                BlockHitResult hit = RaycastHelper.findDetachRift((Entity)Minecraft.m_91087_().f_91074_, RaycastHelper.DETACH);
                if (hit.m_6662_() == HitResult.Type.BLOCK && (blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(hit.m_82425_())) instanceof DetachedRiftBlockEntity) {
                    DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)blockEntity;
                    strings.add("Size: " + rift.size);
                }
            }
        });
        DimensionalDoorsClient.registerCompats();
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlerTypes.TESSELATING_LOOM.get()), TesselatingLoomScreen::new);
        DimensionalDoorsClient.initBlockEntitiesClient();
        ModBlocks.initClient();
        AutoConfig.getGuiRegistry(ModConfig.class).registerPredicateProvider((i18n, field, config, defaults, registry) -> Collections.singletonList(ENTRY_BUILDER.startStrList((Component)Component.m_237115_((String)i18n), ((Set)Utils.getUnsafely((Field)field, (Object)config, (Object)defaults)).stream().toList()).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, newValue.stream().collect(Collectors.toSet()))).build()), DimensionalDoorsClient.isSetOfType(new Type[]{String.class}));
        DimensionalDoorsClient.registerListeners();
        ClientPacketHandler.init();
    }

    private static void registerCompats() {
        if (Platform.isModLoaded((String)"iris") || Platform.isModLoaded((String)"oculus")) {
            detector = new IrisCompat();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initEntitiesClient(BiConsumer<EntityType, EntityRendererProvider> consumer) {
        consumer.accept((EntityType)ModEntityTypes.MONOLITH.get(), MonolithRenderer::new);
        consumer.accept((EntityType)ModEntityTypes.MASK.get(), context -> new EntityRenderer<MaskEntity>(context){

            public ResourceLocation getTextureLocation(MaskEntity entity) {
                return new ResourceLocation("blep");
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initBlockEntitiesClient() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.ENTRANCE_RIFT.get()), context -> new EntranceRiftBlockEntityRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.DETACHED_RIFT.get()), ctx -> new DetachedRiftBlockEntityRenderer());
    }

    private static Predicate<Field> isListOfType(Type ... types) {
        return field -> {
            if (List.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                return args.length == 1 && Stream.of(types).anyMatch(type -> Objects.equals(args[0], type));
            }
            return false;
        };
    }

    private static Predicate<Field> isSetOfType(Type ... types) {
        return field -> {
            if (Set.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                return args.length == 1 && Stream.of(types).anyMatch(type -> Objects.equals(args[0], type));
            }
            return false;
        };
    }

    private static void registerListeners() {
        ClientReloadShadersEvent.EVENT.register((provider, sink) -> {
            try {
                sink.registerShader(new ShaderInstance(provider, "dimensional_portal", DefaultVertexFormat.f_85814_), ModShaders::setDimensionalPortal);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void initParticles(BiConsumer<ParticleType<? extends ParticleOptions>, ParticleProvider<?>> specialProvider, BiConsumer<ParticleType<?>, Function<SpriteSet, ? extends ParticleProvider<? extends ParticleOptions>>> spriteProivder) {
        specialProvider.accept((ParticleType<? extends ParticleOptions>)((ParticleType)ModParticleTypes.MONOLITH.get()), (particleOptions, clientLevel, x, y, z, g, h, i) -> new MonolithParticle(clientLevel, x, y, z));
        spriteProivder.accept((ParticleType)ModParticleTypes.RIFT.get(), RiftParticle.Factory::new);
        spriteProivder.accept((ParticleType)ModParticleTypes.LIMBO_ASH.get(), LimboAshParticle.Factory::new);
    }
}

