/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlockRegistrar;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.client.DimensionalDoorsClient;
import org.jetbrains.annotations.Nullable;

public class DimensionalDoorsModelLoadingPlugin
implements ModelLoadingPlugin {
    public void onInitializeModelLoader(ModelLoadingPlugin.Context pluginContext) {
        BlockStateResolver resolver = new BlockStateResolver(){

            public void resolveBlockStates(BlockStateResolver.Context context) {
                ResourceLocation identifier = BuiltInRegistries.f_256975_.m_7981_((Object)context.block());
                DimensionalDoorBlockRegistrar blockRegistrar = DimensionalDoors.getDimensionalDoorBlockRegistrar();
                if (blockRegistrar.isMapped(identifier)) {
                    ResourceLocation mapped = blockRegistrar.get(identifier);
                    Block original = (Block)BuiltInRegistries.f_256975_.m_7745_(mapped);
                    original.m_49965_().m_61056_().forEach(blockState -> {
                        BlockState state = UnravelUtil.copyState(context.block(), blockState);
                        UnbakedModel model = context.getOrLoadModel((ResourceLocation)BlockModelShaper.m_110895_((BlockState)blockState));
                        context.setModel((BlockState)state.m_61124_((Property)WaterLoggableDoorBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), model);
                        context.setModel(state, model);
                    });
                }
            }
        };
        ModelResolver modelResolver = new ModelResolver(){

            @Nullable
            public UnbakedModel resolveModel(ModelResolver.Context context) {
                if (context.id().m_135815_().contains("item_ag_dim_")) {
                    return context.getOrLoadModel(DimensionalDoorsClient.childItem);
                }
                return null;
            }
        };
        pluginContext.resolveModel().register((Object)modelResolver);
        DimensionalDoors.getDimensionalDoorBlockRegistrar().getGennedIds().stream().filter(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7804_(arg_0)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7745_(arg_0)).forEach(arg_0 -> DimensionalDoorsModelLoadingPlugin.lambda$onInitializeModelLoader$0(pluginContext, resolver, arg_0));
        BuiltInRegistries.f_257033_.m_214010_().stream().map(ResourceKey::m_135782_).filter(a -> a.m_135815_().startsWith("item_ag_dim_")).forEach(location -> pluginContext.addModels(new ResourceLocation[]{new ModelResourceLocation(location, "inventory")}));
    }

    private static /* synthetic */ void lambda$onInitializeModelLoader$0(ModelLoadingPlugin.Context pluginContext, 1 resolver, Block block) {
        pluginContext.registerBlockStateResolver(block, (BlockStateResolver)resolver);
    }
}

