/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.client.effect.DimensionSpecialEffectsExtensions;
import org.dimdev.dimdoors.client.effect.forge.DungeonDimensionEffectImpl;
import org.dimdev.dimdoors.listener.pocket.PocketListenerUtil;
import org.dimdev.dimdoors.world.pocket.type.addon.SkyAddon;
import org.joml.Matrix4f;

public class DungeonDimensionEffect
extends DimensionSpecialEffects
implements DimensionSpecialEffectsExtensions {
    public static DungeonDimensionEffect INSTANCE = new DungeonDimensionEffect();

    private DungeonDimensionEffect() {
        super(-30.0f, false, DimensionSpecialEffects.SkyType.NONE, false, true);
    }

    public Vec3 m_5927_(Vec3 fogColor, float brightness) {
        return fogColor;
    }

    public boolean m_5781_(int x, int y) {
        return false;
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        ClientLevel world = level;
        List<SkyAddon> skyAddons = PocketListenerUtil.applicableAddonsClient(SkyAddon.class, (Level)world, camera.m_90588_());
        SkyAddon skyAddon = null;
        if (skyAddons.size() > 0) {
            skyAddon = skyAddons.get(0);
        }
        if (skyAddon != null) {
            ResourceLocation key = skyAddon.getEffect();
            if (key.equals((Object)BuiltinDimensionTypes.f_223544_)) {
                this.renderEndSky(poseStack);
            } else if (key.equals((Object)BuiltinDimensionTypes.f_223542_)) {
                this.renderOverworld(skyAddon, poseStack, projectionMatrix, partialTick, isFoggy, setupFog);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderEffect(DimensionSpecialEffects effect, ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        DungeonDimensionEffectImpl.renderEffect(effect, (ClientLevel)var1_1, (int)var2_2, (float)var3_3, (PoseStack)var4_4, (Camera)var5_5, (Matrix4f)var6_6, (boolean)var7_7, (Runnable)var8_8);
    }

    private void renderEndSky(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TheEndPortalRenderer.f_112626_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            poseStack.m_85836_();
            if (i == 1) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            if (i == 2) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            if (i == 3) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            }
            if (i == 4) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            if (i == 5) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public void renderOverworld(SkyAddon info, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, boolean isFoggy, Runnable skyFogSetup) {
        float q;
        float p;
        float o;
        int m;
        float k;
        LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
        skyFogSetup.run();
        if (isFoggy) {
            return;
        }
        FogRenderer.m_109036_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        float g = Mth.m_14089_((float)(info.getTimeOfDay() * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        RenderSystem.setShaderColor((float)(0.529f * g), (float)(0.808f * g), (float)(0.922f * g), (float)1.0f);
        ShaderInstance shaderInstance = RenderSystem.getShader();
        levelRenderer.f_109472_.m_85921_();
        levelRenderer.f_109472_.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderInstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float[] fs = this.m_7518_(info.getTimeOfDay(), partialTick);
        if (fs != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float i = Mth.m_14031_((float)info.getSunAngle()) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(i));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float j = fs[0];
            k = fs[1];
            float l = fs[2];
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(j, k, l, fs[3]).m_5752_();
            m = 16;
            for (int n = 0; n <= 16; ++n) {
                o = (float)n * ((float)Math.PI * 2) / 16.0f;
                p = Mth.m_14031_((float)o);
                q = Mth.m_14089_((float)o);
                bufferBuilder.m_252986_(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).m_85950_(fs[0], fs[1], fs[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            poseStack.m_85849_();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(info.getTimeOfDay() * 360.0f));
        Matrix4f matrix4f2 = poseStack.m_85850_().m_252922_();
        k = 30.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LevelRenderer.f_109455_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f2, -k, 100.0f, -k).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f2, k, 100.0f, -k).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f2, k, 100.0f, k).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f2, -k, 100.0f, k).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        k = 20.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LevelRenderer.f_109454_);
        int r = info.getMoonPhase();
        int s = r % 4;
        m = r / 4 % 2;
        float t = (float)s / 4.0f;
        o = (float)m / 2.0f;
        p = (float)(s + 1) / 4.0f;
        q = (float)(m + 1) / 2.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f2, -k, -100.0f, k).m_7421_(p, q).m_5752_();
        bufferBuilder.m_252986_(matrix4f2, k, -100.0f, k).m_7421_(t, q).m_5752_();
        bufferBuilder.m_252986_(matrix4f2, k, -100.0f, -k).m_7421_(t, o).m_5752_();
        bufferBuilder.m_252986_(matrix4f2, -k, -100.0f, -k).m_7421_(p, o).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        float u = info.getStarBrightness();
        if (u > 0.0f) {
            RenderSystem.setShaderColor((float)u, (float)u, (float)u, (float)u);
            FogRenderer.m_109017_();
            levelRenderer.f_109471_.m_85921_();
            levelRenderer.f_109471_.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            skyFogSetup.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d = Minecraft.m_91087_().f_91074_.m_20299_((float)partialTick).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)Minecraft.m_91087_().f_91073_);
        if (d < 0.0) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 12.0f, 0.0f);
            levelRenderer.f_109473_.m_85921_();
            levelRenderer.f_109473_.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderInstance);
            VertexBuffer.m_85931_();
            poseStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    @Override
    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        return true;
    }

    @Override
    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return true;
    }
}

