/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.WorldGenLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.command.WorldeditHelper;
import org.dimdev.dimdoors.command.arguments.BlockPlacementTypeArgumentType;
import org.dimdev.dimdoors.command.arguments.PocketTemplateArgumentType;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.PocketTemplate;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;

public class PocketCommand {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<UUID, CommandSourceStack> logSetting = new HashMap<UUID, CommandSourceStack>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pocket").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"schematic").then(Commands.m_82127_((String)"place").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pocket_template", (ArgumentType)new PocketTemplateArgumentType()).executes(ctx -> PocketCommand.place(((CommandSourceStack)ctx.getSource()).m_81375_(), PocketTemplateArgumentType.getValue(ctx, "pocket_template"), BlockPlacementType.SECTION_NO_UPDATE))).then(Commands.m_82129_((String)"placement_type", (ArgumentType)new BlockPlacementTypeArgumentType()).executes(ctx -> PocketCommand.place(((CommandSourceStack)ctx.getSource()).m_81375_(), PocketTemplateArgumentType.getValue(ctx, "pocket_template"), BlockPlacementTypeArgumentType.getBlockPlacementType((CommandContext<CommandSourceStack>)ctx, "placement_type"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"load").requires(source -> Platform.isModLoaded((String)"worldedit"))).then(Commands.m_82129_((String)"pocket_template", (ArgumentType)new PocketTemplateArgumentType()).executes(ctx -> PocketCommand.load((CommandSourceStack)ctx.getSource(), PocketTemplateArgumentType.getValue(ctx, "pocket_template"))))))).then(Commands.m_82127_((String)"log").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"creation").requires(commandSource -> commandSource.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
            CommandSourceStack commandSource = (CommandSourceStack)ctx.getSource();
            UUID playerUUID = commandSource.m_81375_().m_20148_();
            if (logSetting.containsKey(playerUUID)) {
                logSetting.remove(playerUUID);
                commandSource.m_288197_(() -> Component.m_237115_((String)"commands.pocket.log.creation.off"), false);
            } else {
                logSetting.put(playerUUID, commandSource);
                commandSource.m_288197_(() -> Component.m_237115_((String)"commands.pocket.log.creation.on"), false);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires(src -> src.m_6761_(4))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Dumping pocket data"), false);
            CompletableFuture.runAsync(() -> {
                try {
                    PocketLoader.getInstance().dump();
                }
                catch (Exception e) {
                    LOGGER.error("Error dumping pocket data", (Throwable)e);
                }
            }).thenRun(() -> ((CommandSourceStack)ctx.getSource()).m_81377_().execute(() -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Dumped pocket data"), false)));
            return 1;
        })));
    }

    private static int load(CommandSourceStack source, PocketTemplate template) throws CommandSyntaxException {
        try {
            return WorldeditHelper.load(source, template);
        }
        catch (NoClassDefFoundError e) {
            return 0;
        }
    }

    private static int place(ServerPlayer source, PocketTemplate template, BlockPlacementType blockPlacementType) throws CommandSyntaxException {
        SchematicPlacer.place(template.getSchematic(), (WorldGenLevel)source.m_284548_(), source.m_20183_(), blockPlacementType);
        String id = template.getId().toString();
        source.m_5661_((Component)Component.m_237110_((String)"commands.pocket.placedSchem", (Object[])new Object[]{id, source.m_20183_().m_123341_() + ", " + source.m_20183_().m_123342_() + ", " + source.m_20183_().m_123343_(), source.m_9236_().m_46472_().m_135782_().toString()}), true);
        return 1;
    }
}

