/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.core.item.ArchitecturyRecordItem;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.fluid.ModFluids;
import org.dimdev.dimdoors.item.DimensionalEraserItem;
import org.dimdev.dimdoors.item.MaskWandItem;
import org.dimdev.dimdoors.item.ModArmorMaterials;
import org.dimdev.dimdoors.item.RiftBladeItem;
import org.dimdev.dimdoors.item.RiftConfigurationToolItem;
import org.dimdev.dimdoors.item.RiftKeyItem;
import org.dimdev.dimdoors.item.RiftRemoverItem;
import org.dimdev.dimdoors.item.RiftSignatureItem;
import org.dimdev.dimdoors.item.RiftStabilizerItem;
import org.dimdev.dimdoors.item.StabilizedRiftSignatureItem;
import org.dimdev.dimdoors.sound.ModSoundEvents;

public final class ModItems {
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_256913_);
    public static final RegistrySupplier<Item> WORLD_THREAD = ModItems.registerRegular("world_thread", Item::new);
    public static final RegistrySupplier<Item> INFRANGIBLE_FIBER = ModItems.registerRegular("infrangible_fiber", properties -> new Item(properties.m_41486_()));
    public static final RegistrySupplier<Item> FRAYED_FILAMENTS = ModItems.registerRegular("frayed_filament", Item::new);
    public static final RegistrySupplier<Item> RIFT_CONFIGURATION_TOOL = ModItems.registerRegular("rift_configuration_tool", RiftConfigurationToolItem::new);
    public static final RegistrySupplier<Item> RIFT_BLADE = ModItems.registerRegular("rift_blade", properties -> new RiftBladeItem(properties.m_41503_(100)));
    public static final RegistrySupplier<Item> RIFT_REMOVER = ModItems.registerRegular("rift_remover", properties -> new RiftRemoverItem(properties.m_41487_(1).m_41503_(100)));
    public static final RegistrySupplier<Item> RIFT_SIGNATURE = ModItems.registerRegular("rift_signature", properties -> new RiftSignatureItem(properties.m_41487_(1).m_41503_(1), true));
    public static final RegistrySupplier<Item> STABILIZED_RIFT_SIGNATURE = ModItems.registerRegular("stabilized_rift_signature", properties -> new StabilizedRiftSignatureItem(properties.m_41487_(1).m_41503_(20)));
    public static final RegistrySupplier<Item> RIFT_STABILIZER = ModItems.registerRegular("rift_stabilizer", properties -> new RiftStabilizerItem(properties.m_41487_(1).m_41503_(6)));
    public static final RegistrySupplier<Item> RIFT_KEY = ModItems.registerRegular("rift_key", properties -> new RiftKeyItem(properties.m_41486_().m_41487_(1)));
    public static final RegistrySupplier<Item> DIMENSIONAL_ERASER = ModItems.registerRegular("dimensional_eraser", properties -> new DimensionalEraserItem(properties.m_41503_(100)));
    public static final RegistrySupplier<Item> MONOLITH_SPAWNER = ModItems.registerRegular("monolith_spawner", properties -> new ArchitecturySpawnEggItem(ModEntityTypes.MONOLITH, 0xFFFFFF, 0xFFFFFF, properties));
    public static final RegistrySupplier<Item> WORLD_THREAD_HELMET = ModItems.registerRegular("world_thread_helmet", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.WORLD_THREAD, ArmorItem.Type.HELMET, properties));
    public static final RegistrySupplier<Item> WORLD_THREAD_CHESTPLATE = ModItems.registerRegular("world_thread_chestplate", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.WORLD_THREAD, ArmorItem.Type.CHESTPLATE, properties));
    public static final RegistrySupplier<Item> WORLD_THREAD_LEGGINGS = ModItems.registerRegular("world_thread_leggings", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.WORLD_THREAD, ArmorItem.Type.LEGGINGS, properties));
    public static final RegistrySupplier<Item> WORLD_THREAD_BOOTS = ModItems.registerRegular("world_thread_boots", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.WORLD_THREAD, ArmorItem.Type.BOOTS, properties));
    public static final RegistrySupplier<Item> MASK_WAND = ModItems.registerRegular("mask_wand", properties -> new MaskWandItem(properties.m_41487_(100)));
    public static final RegistrySupplier<Item> STABLE_FABRIC = ModItems.registerRegular("stable_fabric", Item::new);
    public static final RegistrySupplier<Item> CREEPY_RECORD = ModItems.registerRegular("creepy_record", properties -> new ArchitecturyRecordItem(10, ModSoundEvents.CREEPY, properties.m_41487_(1), 317));
    public static final RegistrySupplier<Item> WHITE_VOID_RECORD = ModItems.registerRegular("white_void_record", properties -> new ArchitecturyRecordItem(10, ModSoundEvents.WHITE_VOID, properties.m_41487_(1), 225));
    public static final RegistrySupplier<Item> THEY_STARE_BACK_RECORD = ModItems.registerRegular("they_stare_back_record", properties -> new ArchitecturyRecordItem(10, ModSoundEvents.THEY_STARE_BACK, properties.m_41487_(1), 226));
    public static final RegistrySupplier<Item> ETERNAL_FLUID_BUCKET = ModItems.registerRegular("eternal_fluid_bucket", properties -> new ArchitecturyBucketItem(ModFluids.ETERNAL_FLUID, properties.m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistrySupplier<Item> LEAK_BUCKET = ModItems.registerDecay("leak_bucket", properties -> new ArchitecturyBucketItem(ModFluids.LEAK, properties.m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistrySupplier<Item> MASK_SHARD = ModItems.registerRegular("mask_shard", Item::new);
    public static final RegistrySupplier<Item> FUZZY_FIREBALL = ModItems.registerRegular("fuzzy_fireball", Item::new);
    public static final RegistrySupplier<Item> FABRIC_OF_FINALITY = ModItems.registerRegular("fabric_of_finality", Item::new);
    public static final RegistrySupplier<Item> LIMINAL_LINT = ModItems.registerRegular("liminal_lint", Item::new);
    public static final RegistrySupplier<Item> ENDURING_FIBERS = ModItems.registerRegular("enduring_fibers", Item::new);
    public static final RegistrySupplier<Item> RIFT_PEARL = ModItems.registerRegular("rift_pearl", Item::new);
    public static final RegistrySupplier<Item> AMALGAM_LUMP = ModItems.registerDecay("amalgam_lump", Item::new);
    public static final RegistrySupplier<Item> CLOD = ModItems.registerDecay("clod", Item::new);
    public static final RegistrySupplier<Item> GARMENT_OF_REALITY_HELMET = ModItems.registerRegular("garment_of_reality_helmet", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GARMENT_OF_REALITY, ArmorItem.Type.HELMET, properties));
    public static final RegistrySupplier<Item> GARMENT_OF_REALITY_CHESTPLATE = ModItems.registerRegular("garment_of_reality_chestplate", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GARMENT_OF_REALITY, ArmorItem.Type.CHESTPLATE, properties));
    public static final RegistrySupplier<Item> GARMENT_OF_REALITY_LEGGINGS = ModItems.registerRegular("garment_of_reality_leggings", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GARMENT_OF_REALITY, ArmorItem.Type.LEGGINGS, properties));
    public static final RegistrySupplier<Item> GARMENT_OF_REALITY_BOOTS = ModItems.registerRegular("garment_of_reality_boots", properties -> new ArmorItem((ArmorMaterial)ModArmorMaterials.GARMENT_OF_REALITY, ArmorItem.Type.BOOTS, properties));
    public static final Set<Item> DOOR_ITEMS = new HashSet<Item>();
    public static DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_279569_);
    public static final RegistrySupplier<CreativeModeTab> DIMENSIONAL_DOORS = CREATIVE_TABS.register("dimensional_doors", () -> CreativeTabRegistry.create(builder -> builder.m_257737_(() -> new ItemStack((ItemLike)RIFT_BLADE.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.dimdoors.dimensional_doors"))));
    public static final RegistrySupplier<CreativeModeTab> DECAY = CREATIVE_TABS.register("decay", () -> CreativeTabRegistry.create(builder -> builder.m_257737_(() -> new ItemStack((ItemLike)ModBlocks.UNRAVELED_FENCE.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.dimdoors.decay"))));

    public static RegistrySupplier<Item> registerRegular(String name, Function<Item.Properties, Item> item) {
        return ModItems.register(name, () -> (Item)item.apply(new Item.Properties().arch$tab(DIMENSIONAL_DOORS)));
    }

    public static RegistrySupplier<Item> registerDecay(String name, Function<Item.Properties, Item> item) {
        return ModItems.register(name, () -> (Item)item.apply(new Item.Properties().arch$tab(DECAY)));
    }

    public static RegistrySupplier<Item> register(String name, Supplier<Item> item) {
        return REGISTRY.register(name, item);
    }

    public static void init() {
        CREATIVE_TABS.register();
        REGISTRY.register();
    }
}

