/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.component.forge;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.item.component.CounterComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CounterComponentImpl
implements CounterComponent {
    private static final ResourceLocation IDENTIFIER = DimensionalDoors.id("counter");
    public static final Capability<CounterComponentImpl> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<CounterComponentImpl>(){});
    private int counter = 0;

    @Override
    public int increment() {
        ++this.counter;
        return this.counter;
    }

    @Override
    public int count() {
        return this.counter;
    }

    @Override
    public void reset() {
        this.counter = 0;
    }

    private CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("counter", this.counter);
        return tag;
    }

    private void readFromNbt(CompoundTag arg) {
        arg.m_128405_("counter", this.counter);
    }

    public static CounterComponent get(ItemStack provider) {
        return (CounterComponent)provider.getCapability(INSTANCE).resolve().get();
    }

    @Mod.EventBusSubscriber(modid="dimdoors", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final CounterComponentImpl backend = new CounterComponentImpl();
        private final LazyOptional<CounterComponentImpl> optionalData = LazyOptional.of(() -> this.backend);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return INSTANCE.orEmpty(capability, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.writeToNbt();
        }

        public void deserializeNBT(CompoundTag arg) {
            this.backend.readFromNbt(arg);
        }

        @SubscribeEvent
        public static void attach(AttachCapabilitiesEvent<ItemStack> event) {
            if (((ItemStack)event.getObject()).m_150930_((Item)ModItems.RIFT_CONFIGURATION_TOOL.get())) {
                Provider provider = new Provider();
                event.addCapability(IDENTIFIER, (ICapabilityProvider)provider);
            }
        }
    }
}

