/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network.packet.s2c;

import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.network.client.ClientPacketHandler;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;

public class SyncPocketAddonsS2CPacket {
    public static final ResourceLocation ID = DimensionalDoors.id("sync_pocket_addons");
    private ResourceKey<Level> world;
    private int gridSize;
    private int pocketId;
    private int pocketRange;
    private List<AutoSyncedAddon> addons;

    @OnlyIn(value=Dist.CLIENT)
    public SyncPocketAddonsS2CPacket() {
    }

    public SyncPocketAddonsS2CPacket(ResourceKey<Level> world, int gridSize, int pocketId, int pocketRange, List<AutoSyncedAddon> addons) {
        this.world = world;
        this.gridSize = gridSize;
        this.pocketId = pocketId;
        this.pocketRange = pocketRange;
        this.addons = addons;
    }

    public SyncPocketAddonsS2CPacket(FriendlyByteBuf buf) {
        this((ResourceKey<Level>)buf.m_236801_(Registries.f_256858_), buf.readInt(), buf.readInt(), buf.readInt(), AutoSyncedAddon.readAutoSyncedAddonList(buf));
    }

    public FriendlyByteBuf write(FriendlyByteBuf buf) {
        buf.m_236858_(this.world);
        buf.writeInt(this.gridSize);
        buf.writeInt(this.pocketId);
        buf.writeInt(this.pocketRange);
        AutoSyncedAddon.writeAutoSyncedAddonList(buf, this.addons);
        return buf;
    }

    public void apply(Supplier<NetworkManager.PacketContext> context) {
        ClientPacketHandler.getHandler().onSyncPocketAddons(this);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPocketId() {
        return this.pocketId;
    }

    public int getPocketRange() {
        return this.pocketRange;
    }

    public List<AutoSyncedAddon> getAddons() {
        return this.addons;
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }
}

