/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class VoidGenerator
extends LazyPocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "void";
    private String width;
    private Equation heightEquation;
    private String height;
    private Equation widthEquation;
    private String length;
    private Equation lengthEquation;

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        Object pocket = DimensionalRegistry.getPocketDirectory((ResourceKey<Level>)parameters.world().m_46472_()).newPocket(builder);
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        ((Pocket)pocket).setSize((int)this.widthEquation.apply(variableMap), (int)this.heightEquation.apply(variableMap), (int)this.lengthEquation.apply(variableMap));
        return pocket;
    }

    @Override
    public PocketGenerator.PocketGeneratorType<? extends PocketGenerator> getType() {
        return (PocketGenerator.PocketGeneratorType)PocketGenerator.PocketGeneratorType.VOID.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public Vec3i getSize(PocketGenerationContext parameters) {
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        return new Vec3i((int)this.widthEquation.apply(variableMap), (int)this.heightEquation.apply(variableMap), (int)this.lengthEquation.apply(variableMap));
    }

    @Override
    public PocketGenerator fromNbt(CompoundTag nbt, ResourceManager manager) {
        super.fromNbt(nbt, manager);
        try {
            this.width = nbt.m_128461_("width");
            this.widthEquation = Equation.parse(this.width);
            this.height = nbt.m_128461_("height");
            this.heightEquation = Equation.parse(this.height);
            this.length = nbt.m_128461_("length");
            this.lengthEquation = Equation.parse(this.length);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error((Object)e);
        }
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.m_128359_("width", this.width);
        nbt.m_128359_("height", this.height);
        nbt.m_128359_("length", this.length);
        return nbt;
    }

    @Override
    public LazyPocketGenerator cloneWithEmptyModifiers(BlockPos originalOrigin) {
        VoidGenerator generator = (VoidGenerator)super.cloneWithEmptyModifiers(originalOrigin);
        generator.width = this.width;
        generator.height = this.height;
        generator.length = this.length;
        return generator;
    }

    @Override
    public LazyPocketGenerator getNewInstance() {
        return new VoidGenerator();
    }
}

