/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractLazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class AbsoluteRiftBlockEntityModifier
extends AbstractLazyModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "block_entity";
    private Map<BlockPos, RiftBlockEntity> rifts;
    private Map<BlockPos, CompoundTag> serializedRifts;

    public AbsoluteRiftBlockEntityModifier() {
    }

    public AbsoluteRiftBlockEntityModifier(Map<BlockPos, RiftBlockEntity> rifts) {
        this.rifts = rifts;
    }

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        this.serializedRifts = StreamUtils.execute(() -> ((Stream)nbt.m_128437_("rifts", 10).parallelStream().unordered()).map(CompoundTag.class::cast).filter(compound -> {
            if (compound.m_128441_("Pos")) {
                return true;
            }
            LOGGER.error("Discarding rift on deserialization since \"Pos\" tag was not set.");
            return false;
        }).collect(Collectors.toConcurrentMap(compound -> {
            int[] ints = compound.m_128465_("Pos");
            return new BlockPos(ints[0], ints[1], ints[2]);
        }, compound -> compound)));
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowResource) {
        ListTag riftsNbt;
        super.toNbtInternal(nbt, allowResource);
        if (this.rifts != null) {
            riftsNbt = StreamUtils.execute(() -> ((Stream)this.rifts.values().parallelStream().unordered()).map(rift -> {
                CompoundTag e = new CompoundTag();
                rift.m_183515_(e);
                return e;
            }).collect(Collectors.toCollection(ListTag::new)));
        } else {
            riftsNbt = new ListTag();
            riftsNbt.addAll(this.serializedRifts.values());
        }
        nbt.m_128365_("rifts", (Tag)riftsNbt);
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.ABSOLUTE_RIFT_BLOCK_ENTITY_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        if (!manager.isPocketLazy()) {
            ServerLevel world = DimensionalDoors.getWorld(manager.getPocket().getWorld());
            this.rifts.values().forEach(arg_0 -> ((ServerLevel)world).m_151523_(arg_0));
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }

    @Override
    public void applyToChunk(LazyGenerationPocket pocket, ChunkAccess chunk) {
        BoundingBox chunkBox = BlockBoxUtil.getBox(chunk);
        if (this.rifts != null) {
            ((Stream)this.rifts.entrySet().stream().unordered()).filter(entry -> chunkBox.m_71051_((Vec3i)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((pos, rift) -> {
                this.rifts.remove(pos);
                chunk.m_142169_((BlockEntity)rift);
            });
        } else {
            ((Stream)this.serializedRifts.entrySet().stream().unordered()).filter(entry -> chunkBox.m_71051_((Vec3i)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((pos, riftNbt) -> {
                this.rifts.remove(pos);
                chunk.m_142169_(BlockEntity.m_155241_((BlockPos)pos, (BlockState)chunk.m_8055_(pos), (CompoundTag)riftNbt));
            });
        }
    }
}

