/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.block.entity.MutableBlockEntityType;
import org.dimdev.dimdoors.api.util.NbtEquations;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.modifier.AbstractLazyCompatibleModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.IdMarker;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class DimensionalDoorModifier
extends AbstractLazyCompatibleModifier {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "door";
    private Direction facing;
    private String doorTypeString;
    private DimensionalDoorBlock doorType;
    private CompoundTag doorData;
    private String doorDataReference;
    private String x;
    private String y;
    private String z;
    private Equation xEquation;
    private Equation yEquation;
    private Equation zEquation;

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        String facingString = nbt.m_128461_("facing");
        this.facing = Direction.m_122402_((String)nbt.m_128461_("facing"));
        if (this.facing == null || this.facing.m_122434_().m_122478_()) {
            throw new RuntimeException("Could not interpret facing direction \"" + facingString + "\"");
        }
        this.doorTypeString = nbt.m_128461_("door_type");
        Block doorBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)this.doorTypeString));
        if (!(doorBlock instanceof DimensionalDoorBlock)) {
            throw new RuntimeException("Could not interpret door type \"" + this.doorTypeString + "\"");
        }
        this.doorType = (DimensionalDoorBlock)doorBlock;
        if (nbt.m_128435_("rift_data") == 8) {
            this.doorDataReference = nbt.m_128461_("rift_data");
            this.doorData = PocketLoader.getInstance().getDataNbtCompound(this.doorDataReference);
        } else if (nbt.m_128435_("rift_data") == 10) {
            this.doorData = nbt.m_128469_("rift_data");
        }
        try {
            this.x = nbt.m_128461_("x");
            this.y = nbt.m_128461_("y");
            this.z = nbt.m_128461_("z");
            this.xEquation = Equation.parse(this.x);
            this.yEquation = Equation.parse(this.y);
            this.zEquation = Equation.parse(this.z);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error((Object)e);
        }
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.m_128359_("facing", this.facing.m_7912_());
        nbt.m_128359_("door_type", this.doorTypeString);
        if (this.doorDataReference != null) {
            nbt.m_128359_("rift_data", this.doorDataReference);
        } else if (this.doorData != null) {
            nbt.m_128365_("rift_data", (Tag)this.doorData);
        }
        nbt.m_128359_("x", this.x);
        nbt.m_128359_("y", this.y);
        nbt.m_128359_("z", this.z);
        return nbt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("facing", (Object)this.facing).add("doorTypeString", (Object)this.doorTypeString).add("doorType", (Object)this.doorType).add("doorData", (Object)this.doorData).add("doorDataReference", (Object)this.doorDataReference).add("x", (Object)this.x).add("y", (Object)this.y).add("z", (Object)this.z).add("xEquation", (Object)this.xEquation).add("yEquation", (Object)this.yEquation).add("zEquation", (Object)this.zEquation).toString();
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.DIMENSIONAL_DOOR_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Map<String, Double> variableMap = manager.getPocket().toVariableMap(new HashMap<String, Double>());
        BlockPos pocketOrigin = manager.getPocket().getOrigin();
        BlockPos pos = new BlockPos((int)(this.xEquation.apply(variableMap) + (double)pocketOrigin.m_123341_()), (int)(this.yEquation.apply(variableMap) + (double)pocketOrigin.m_123342_()), (int)(this.zEquation.apply(variableMap) + (double)pocketOrigin.m_123343_()));
        BlockState lower = (BlockState)((BlockState)this.doorType.m_49966_().m_61124_((Property)DimensionalDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)DimensionalDoorBlock.f_52726_, (Comparable)this.facing);
        BlockState upper = (BlockState)((BlockState)this.doorType.m_49966_().m_61124_((Property)DimensionalDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)DimensionalDoorBlock.f_52726_, (Comparable)this.facing);
        EntranceRiftBlockEntity rift = (EntranceRiftBlockEntity)((MutableBlockEntityType)((Object)ModBlockEntityTypes.ENTRANCE_RIFT.get())).m_155264_(pos, lower);
        rift.m_142339_((Level)parameters.world());
        if (this.doorData == null) {
            rift.setDestination(new IdMarker(manager.nextId()));
        } else {
            CompoundTag solvedDoorData = NbtEquations.solveNbtCompoundEquations(this.doorData, variableMap);
            rift.setData(RiftData.fromNbt(solvedDoorData));
        }
        manager.add(rift);
        if (manager.getPocket() instanceof LazyGenerationPocket) {
            this.queueChunkModificationTask(new ChunkPos(pos), chunk -> {
                chunk.m_6978_(pos, lower, false);
                chunk.m_142169_((BlockEntity)rift);
            });
            this.queueChunkModificationTask(new ChunkPos(pos.m_7494_()), chunk -> chunk.m_6978_(pos.m_7494_(), upper, false));
        } else {
            ServerLevel world = parameters.world();
            world.m_46597_(pos, lower);
            world.m_46597_(pos.m_7494_(), upper);
            world.m_151523_((BlockEntity)rift);
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }
}

