/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StringRepresentable;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbstractModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.LocalReference;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RelativeReferenceModifier
extends AbstractModifier {
    public static final String KEY = "relative";
    private int point_a;
    private int point_b;
    private ConnectionType connection = ConnectionType.BOTH;

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        this.point_a = nbt.m_128451_("point_a");
        this.point_b = nbt.m_128451_("point_b");
        this.connection = nbt.m_128441_("connection") ? ConnectionType.fromString(nbt.m_128461_("connection")) : ConnectionType.BOTH;
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        nbt.m_128405_("point_a", this.point_a);
        nbt.m_128405_("point_b", this.point_b);
        nbt.m_128359_("connection", this.connection.m_7912_());
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.RELATIVE_REFERENCE_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Optional<Location> riftA = manager.get(this.point_a).map(rift -> new Location((ServerLevel)rift.m_58904_(), rift.m_58899_()));
        Optional<Location> riftB = manager.get(this.point_b).map(rift -> new Location((ServerLevel)rift.m_58904_(), rift.m_58899_()));
        if (riftA.isPresent() && riftB.isPresent()) {
            RiftReference link1 = LocalReference.tryMakeRelative(riftA.get(), riftB.get());
            RiftReference link2 = LocalReference.tryMakeRelative(riftB.get(), riftA.get());
            manager.consume(this.point_a, rift -> this.addLink((RiftBlockEntity)rift, link1));
            if (this.connection == ConnectionType.BOTH) {
                manager.consume(this.point_b, rift -> this.addLink((RiftBlockEntity)rift, link2));
            }
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("point_a", this.point_a).add("point_b", this.point_b).add("connection", (Object)this.connection.m_7912_()).toString();
    }

    private boolean addLink(RiftBlockEntity rift, RiftReference link) {
        rift.setDestination(link);
        return true;
    }

    public static enum ConnectionType implements StringRepresentable
    {
        BOTH("both"),
        ONE_WAY("one_way");

        private String id;

        private ConnectionType(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public static ConnectionType fromString(String name) {
            return "one_way".equalsIgnoreCase(name) ? ONE_WAY : BOTH;
        }
    }
}

