/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.api.util.NbtEquations;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.modifier.AbstractModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RiftDataModifier
extends AbstractModifier {
    public static final String KEY = "rift_data";
    private CompoundTag doorData;
    private String doorDataReference;
    private List<Integer> ids;

    @Override
    public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
        if (nbt.m_128435_(KEY) == 8) {
            this.doorDataReference = nbt.m_128461_(KEY);
            this.doorData = PocketLoader.getInstance().getDataNbtCompound(this.doorDataReference);
        } else if (nbt.m_128435_(KEY) == 10) {
            this.doorData = nbt.m_128469_(KEY);
        }
        this.ids = RiftDataModifier.stream(nbt.m_128463_("ids")).boxed().collect(Collectors.toList());
        return this;
    }

    public static IntStream stream(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return IntStream.generate(buffer::get).limit(buffer.remaining());
    }

    public static byte[] toByteArray(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        if (this.doorDataReference != null) {
            nbt.m_128359_(KEY, this.doorDataReference);
        } else if (this.doorData != null) {
            nbt.m_128365_(KEY, (Tag)this.doorData);
        }
        nbt.m_128382_("ids", RiftDataModifier.toByteArray(this.ids.stream().mapToInt(Integer::intValue).toArray()));
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return (Modifier.ModifierType)Modifier.ModifierType.RIFT_DATA_MODIFIER_TYPE.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("doorData", (Object)this.doorData).add("doorDataReference", (Object)this.doorDataReference).add("ids", this.ids).toString();
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Map<String, Double> variableMap = manager.getPocket().toVariableMap(new HashMap<String, Double>());
        Consumer<RiftBlockEntity> riftBlockEntityConsumer = this.doorData == null ? rift -> rift.setDestination(VirtualTarget.NoneTarget.INSTANCE) : this.solveData(this.doorData, variableMap);
        manager.foreachConsume((id, rift) -> {
            if (this.ids.contains(id)) {
                riftBlockEntityConsumer.accept((RiftBlockEntity)rift);
                return true;
            }
            return false;
        });
    }

    private Consumer<RiftBlockEntity> solveData(CompoundTag doorData, Map<String, Double> variableMap) {
        CompoundTag solvedDoorData = NbtEquations.solveNbtCompoundEquations(doorData, variableMap);
        return rift -> rift.setData(RiftData.fromNbt(solvedDoorData));
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }
}

