/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.virtual.AbstractVirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.VirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.reference.IdReference;
import org.dimdev.dimdoors.pockets.virtual.reference.PocketGeneratorReference;
import org.dimdev.dimdoors.pockets.virtual.reference.TagReference;
import org.dimdev.dimdoors.pockets.virtual.selection.ConditionalSelector;
import org.dimdev.dimdoors.pockets.virtual.selection.PathSelector;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jetbrains.annotations.Nullable;

public interface ImplementedVirtualPocket
extends VirtualPocket {
    public static final String RESOURCE_STARTING_PATH = "pockets/virtual";
    public static final Registrar<VirtualPocketType<? extends ImplementedVirtualPocket>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("virtual_pocket_type"), (Object[])new VirtualPocketType[0]).build();

    public static ImplementedVirtualPocket deserialize(Tag nbt, @Nullable ResourceManager manager) {
        return switch (nbt.m_7060_()) {
            case 10 -> ImplementedVirtualPocket.deserialize((CompoundTag)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, RESOURCE_STARTING_PATH, nbt.m_7916_(), ResourceUtil.NBT_READER.andThenComposable(nbtElement -> ImplementedVirtualPocket.deserialize(nbtElement, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.m_7060_()));
        };
    }

    public static ImplementedVirtualPocket deserialize(Tag nbt) {
        return ImplementedVirtualPocket.deserialize(nbt, null);
    }

    public static ImplementedVirtualPocket deserialize(CompoundTag nbt, @Nullable ResourceManager manager) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        VirtualPocketType type = (VirtualPocketType)REGISTRY.get(id);
        return type != null ? type.fromNbt(nbt, manager) : ((VirtualPocketType)VirtualPocketType.NONE.get()).fromNbt(nbt, manager);
    }

    public static ImplementedVirtualPocket deserialize(CompoundTag nbt) {
        return ImplementedVirtualPocket.deserialize(nbt, null);
    }

    public static Tag serialize(ImplementedVirtualPocket implementedVirtualPocket, boolean allowReference) {
        return implementedVirtualPocket.toNbt(new CompoundTag(), allowReference);
    }

    public static Tag serialize(ImplementedVirtualPocket implementedVirtualPocket) {
        return ImplementedVirtualPocket.serialize(implementedVirtualPocket, false);
    }

    public ImplementedVirtualPocket fromNbt(CompoundTag var1, @Nullable ResourceManager var2);

    default public ImplementedVirtualPocket fromNbt(CompoundTag nbt) {
        return this.fromNbt(nbt, null);
    }

    public Tag toNbt(CompoundTag var1, boolean var2);

    default public Tag toNbt(CompoundTag nbt) {
        return this.toNbt(nbt, false);
    }

    public VirtualPocketType<? extends ImplementedVirtualPocket> getType();

    public String getKey();

    public static interface VirtualPocketType<T extends ImplementedVirtualPocket> {
        public static final RegistrySupplier<VirtualPocketType<NoneVirtualPocket>> NONE = VirtualPocketType.register(DimensionalDoors.id("none"), () -> NoneVirtualPocket.NONE);
        public static final RegistrySupplier<VirtualPocketType<IdReference>> ID_REFERENCE = VirtualPocketType.register(DimensionalDoors.id("id"), IdReference::new);
        public static final RegistrySupplier<VirtualPocketType<TagReference>> TAG_REFERENCE = VirtualPocketType.register(DimensionalDoors.id("tag"), TagReference::new);
        public static final RegistrySupplier<VirtualPocketType<ImplementedVirtualPocket>> CONDITIONAL_SELECTOR = VirtualPocketType.register(DimensionalDoors.id("conditional"), ConditionalSelector::new);
        public static final RegistrySupplier<VirtualPocketType<PathSelector>> PATH_SELECTOR = VirtualPocketType.register(DimensionalDoors.id("path"), PathSelector::new);

        public ImplementedVirtualPocket fromNbt(CompoundTag var1, @Nullable ResourceManager var2);

        default public ImplementedVirtualPocket fromNbt(CompoundTag nbt) {
            return this.fromNbt(nbt, null);
        }

        public CompoundTag toNbt(CompoundTag var1);

        public static void register() {
        }

        public static <U extends ImplementedVirtualPocket> RegistrySupplier<VirtualPocketType<U>> register(final ResourceLocation id, final Supplier<U> factory) {
            return REGISTRY.register(id, () -> new VirtualPocketType<U>(){

                @Override
                public ImplementedVirtualPocket fromNbt(CompoundTag nbt, ResourceManager manager) {
                    return ((ImplementedVirtualPocket)factory.get()).fromNbt(nbt, manager);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }
            });
        }
    }

    public static class NoneVirtualPocket
    extends AbstractVirtualPocket {
        public static final String KEY = "none";
        public static final NoneVirtualPocket NONE = new NoneVirtualPocket();

        private NoneVirtualPocket() {
        }

        @Override
        public Pocket prepareAndPlacePocket(PocketGenerationContext parameters) {
            throw new UnsupportedOperationException("Cannot place a NoneVirtualPocket");
        }

        @Override
        public PocketGeneratorReference getNextPocketGeneratorReference(PocketGenerationContext parameters) {
            throw new UnsupportedOperationException("Cannot get next pocket generator reference on a NoneVirtualPocket");
        }

        @Override
        public PocketGeneratorReference peekNextPocketGeneratorReference(PocketGenerationContext parameters) {
            throw new UnsupportedOperationException("Cannot peek next pocket generator reference on a NoneVirtualPocket");
        }

        @Override
        public ImplementedVirtualPocket fromNbt(CompoundTag nbt, ResourceManager manager) {
            return this;
        }

        @Override
        public VirtualPocketType<? extends ImplementedVirtualPocket> getType() {
            return (VirtualPocketType)VirtualPocketType.NONE.get();
        }

        @Override
        public String getKey() {
            return KEY;
        }

        @Override
        public double getWeight(PocketGenerationContext parameters) {
            return 0.0;
        }
    }
}

