/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual;

import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.api.util.Weighted;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.VirtualPocketList;
import org.dimdev.dimdoors.pockets.virtual.reference.PocketGeneratorReference;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.jetbrains.annotations.Nullable;

public interface VirtualPocket
extends Weighted<PocketGenerationContext>,
ReferenceSerializable {
    public static final String RESOURCE_STARTING_PATH = "pockets/virtual";

    public static VirtualPocket deserialize(Tag nbt) {
        return VirtualPocket.deserialize(nbt, null);
    }

    public static VirtualPocket deserialize(Tag nbt, @Nullable ResourceManager manager) {
        return switch (nbt.m_7060_()) {
            case 9 -> VirtualPocketList.deserialize((ListTag)nbt, manager);
            case 10 -> ImplementedVirtualPocket.deserialize((CompoundTag)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, RESOURCE_STARTING_PATH, nbt.m_7916_(), ResourceUtil.NBT_READER.andThenComposable(nbtElement -> VirtualPocket.deserialize(nbtElement, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.m_7060_()));
        };
    }

    public static Tag serialize(VirtualPocket virtualPocket, boolean allowReference) {
        if (virtualPocket instanceof VirtualPocketList) {
            return VirtualPocketList.serialize((VirtualPocketList)virtualPocket, allowReference);
        }
        return ImplementedVirtualPocket.serialize((ImplementedVirtualPocket)virtualPocket, allowReference);
    }

    public static Tag serialize(VirtualPocket virtualPocket) {
        return VirtualPocket.serialize(virtualPocket, false);
    }

    public void setResourceKey(String var1);

    public String getResourceKey();

    @Override
    default public void processFlags(Multimap<String, String> flags) {
        Collection reference = flags.get((Object)"reference");
        if (reference.stream().findFirst().map(string -> string.equals("local") || string.equals("global")).orElse(false).booleanValue()) {
            this.setResourceKey(flags.get((Object)"resource_key").stream().findFirst().orElse(null));
        }
    }

    public Pocket prepareAndPlacePocket(PocketGenerationContext var1);

    public PocketGeneratorReference getNextPocketGeneratorReference(PocketGenerationContext var1);

    public PocketGeneratorReference peekNextPocketGeneratorReference(PocketGenerationContext var1);

    default public void init() {
    }
}

