/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual.selection;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.virtual.AbstractVirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.VirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.reference.PocketGeneratorReference;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class ConditionalSelector
extends AbstractVirtualPocket {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "conditional";
    private LinkedHashMap<String, VirtualPocket> pocketMap = Maps.newLinkedHashMap();
    private LinkedHashMap<String, Equation> equationMap = Maps.newLinkedHashMap();

    public ConditionalSelector() {
    }

    public ConditionalSelector(LinkedHashMap<String, VirtualPocket> pocketMap) {
        this.pocketMap = pocketMap;
    }

    public LinkedHashMap<String, VirtualPocket> getPocketMap() {
        return this.pocketMap;
    }

    @Override
    public ImplementedVirtualPocket fromNbt(CompoundTag nbt, ResourceManager manager) {
        ListTag conditionalPockets = nbt.m_128437_("pockets", 10);
        for (int i = 0; i < conditionalPockets.size(); ++i) {
            CompoundTag pocket = conditionalPockets.m_128728_(i);
            String condition = pocket.m_128461_("condition");
            if (this.pocketMap.containsKey(condition)) continue;
            try {
                this.equationMap.put(condition, Equation.parse(condition));
                this.pocketMap.put(condition, VirtualPocket.deserialize(pocket.m_128423_("pocket"), manager));
                continue;
            }
            catch (Equation.EquationParseException e) {
                LOGGER.error("Could not parse pocket conditions equation!", (Throwable)e);
            }
        }
        return this;
    }

    @Override
    public CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        super.toNbtInternal(nbt, allowReference);
        ListTag conditionalPockets = new ListTag();
        this.pocketMap.forEach((condition, pocket) -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("condition", condition);
            compound.m_128365_("pocket", VirtualPocket.serialize(pocket, allowReference));
            conditionalPockets.add((Object)compound);
        });
        nbt.m_128365_("pockets", (Tag)conditionalPockets);
        return nbt;
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters) {
        return this.getNextPocket(parameters).prepareAndPlacePocket(parameters);
    }

    @Override
    public PocketGeneratorReference getNextPocketGeneratorReference(PocketGenerationContext parameters) {
        return this.getNextPocket(parameters).getNextPocketGeneratorReference(parameters);
    }

    @Override
    public PocketGeneratorReference peekNextPocketGeneratorReference(PocketGenerationContext parameters) {
        return this.getNextPocket(parameters).peekNextPocketGeneratorReference(parameters);
    }

    @Override
    public void init() {
        this.pocketMap.values().forEach(VirtualPocket::init);
    }

    @Override
    public ImplementedVirtualPocket.VirtualPocketType<? extends ImplementedVirtualPocket> getType() {
        return (ImplementedVirtualPocket.VirtualPocketType)ImplementedVirtualPocket.VirtualPocketType.CONDITIONAL_SELECTOR.get();
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public double getWeight(PocketGenerationContext parameters) {
        return this.getNextPocket(parameters).getWeight(parameters);
    }

    private VirtualPocket getNextPocket(PocketGenerationContext parameters) {
        for (Map.Entry<String, VirtualPocket> entry : this.pocketMap.entrySet()) {
            if (!this.equationMap.get(entry.getKey()).asBoolean(parameters.toVariableMap(new HashMap<String, Double>()))) continue;
            return entry.getValue();
        }
        return this.pocketMap.values().stream().findFirst().orElse(ImplementedVirtualPocket.NoneVirtualPocket.NONE);
    }
}

