/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.block.entity.TesselatingLoomBlockEntity;
import org.dimdev.dimdoors.recipe.ModRecipeSerializers;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.recipe.ShapedTesselatingRecipe;
import org.dimdev.dimdoors.recipe.TesselatingRecipe;

public class TesselatingShapelessRecipe
implements TesselatingRecipe {
    final NonNullList<Ingredient> ingredients;
    private final ResourceLocation id;
    final ItemStack result;
    final String group;
    final boolean showNotification;
    private final int weavingTime;

    public TesselatingShapelessRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> ingredients, int weavingTime, boolean showNotification) {
        this.id = id;
        this.group = group;
        this.result = result;
        this.ingredients = ingredients;
        this.weavingTime = weavingTime;
        this.showNotification = showNotification;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPELESS_TESSELATING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.SHAPELESS_TESSELATING.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public boolean matches(TesselatingLoomBlockEntity inv, Level level) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemStack = inv.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            ++i;
            stackedContents.m_36468_(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    @Override
    public int weavingTime() {
        return this.weavingTime;
    }

    public ItemStack assemble(TesselatingLoomBlockEntity container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<TesselatingShapelessRecipe> {
        public TesselatingShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonNullList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonNullList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemStack = ShapedTesselatingRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int weavingTime = GsonHelper.m_13824_((JsonObject)json, (String)"weavingtime", (int)200);
            boolean bl = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            return new TesselatingShapelessRecipe(recipeId, string, itemStack, nonNullList, weavingTime, bl);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray ingredientArray) {
            NonNullList nonNullList = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public TesselatingShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            int i = buffer.m_130242_();
            NonNullList nonNullList = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.m_130267_();
            int weavingTime = buffer.readInt();
            boolean bl = buffer.readBoolean();
            return new TesselatingShapelessRecipe(recipeId, string, itemStack, (NonNullList<Ingredient>)nonNullList, weavingTime, bl);
        }

        public void toNetwork(FriendlyByteBuf buffer, TesselatingShapelessRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.weavingTime);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

