/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.registry.RegistryVertex;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;

public class Rift
extends RegistryVertex {
    private static final Logger LOGGER = LogManager.getLogger();
    private Location location;
    private boolean isDetached;
    private LinkProperties properties;

    public Rift(Location location) {
        this.location = location;
        this.setWorld(location.getWorldId());
    }

    public Rift(Location location, boolean isDetached, LinkProperties properties) {
        this.location = location;
        this.isDetached = isDetached;
        this.properties = properties;
    }

    public Rift(UUID id, Location location, boolean isDetached, LinkProperties properties) {
        this.location = location;
        this.isDetached = isDetached;
        this.properties = properties;
        this.id = id;
    }

    public Rift() {
    }

    @Override
    public void sourceGone(RegistryVertex source) {
        super.sourceGone(source);
        RiftBlockEntity riftTileEntity = (RiftBlockEntity)this.location.getBlockEntity();
        if (source instanceof Rift) {
            riftTileEntity.handleSourceGone(((Rift)source).location);
        }
    }

    @Override
    public void targetGone(RegistryVertex target) {
        super.targetGone(target);
        BlockEntity blockEntity = this.location.getBlockEntity();
        if (blockEntity instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)blockEntity;
            if (target instanceof Rift) {
                riftBlockEntity.handleTargetGone(((Rift)target).location);
            }
            riftBlockEntity.updateColor();
        }
    }

    public void targetChanged(RegistryVertex target) {
        LOGGER.debug("Rift " + String.valueOf(this) + " notified of target " + String.valueOf(target) + " having changed. Updating color.");
        BlockEntity blockEntity = this.location.getBlockEntity();
        if (blockEntity instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)blockEntity;
            riftBlockEntity.updateColor();
        }
    }

    public void markDirty() {
        BlockEntity blockEntity = this.location.getBlockEntity();
        if (blockEntity instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)blockEntity;
            riftBlockEntity.updateColor();
        }
        for (Location location : DimensionalRegistry.getRiftRegistry().getSources(this.location)) {
            DimensionalRegistry.getRiftRegistry().getRift(location).targetChanged(this);
        }
    }

    private void updateColor() {
        BlockEntity blockEntity = this.location.getBlockEntity();
        if (blockEntity instanceof RiftBlockEntity) {
            RiftBlockEntity riftBlockEntity = (RiftBlockEntity)blockEntity;
            riftBlockEntity.updateColor();
        }
    }

    @Override
    public RegistryVertex.RegistryVertexType<? extends RegistryVertex> getType() {
        return (RegistryVertex.RegistryVertexType)RegistryVertex.RegistryVertexType.RIFT.get();
    }

    public static CompoundTag toNbt(Rift rift) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("id", rift.id);
        nbt.m_128365_("location", (Tag)Location.toNbt(rift.location));
        nbt.m_128379_("isDetached", rift.isDetached);
        if (rift.properties != null) {
            nbt.m_128365_("properties", (Tag)LinkProperties.toNbt(rift.properties));
        }
        return nbt;
    }

    public static Rift fromNbt(CompoundTag nbt) {
        Rift rift = new Rift();
        rift.id = nbt.m_128342_("id");
        rift.location = Location.fromNbt(nbt.m_128469_("location"));
        rift.isDetached = nbt.m_128471_("isDetached");
        if (nbt.m_128441_("properties")) {
            rift.properties = LinkProperties.fromNbt(nbt.m_128469_("properties"));
        }
        return rift;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    public void setDetached(boolean detached) {
        this.isDetached = detached;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    public void setProperties(LinkProperties properties) {
        this.properties = properties;
    }
}

