/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EscapeTarget
extends VirtualTarget
implements EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ResourceKey<Level> targetWorldResourceKey;
    public static final Codec<EscapeTarget> CODEC;
    protected final boolean canEscapeLimbo;

    public EscapeTarget(boolean canEscapeLimbo) {
        this.canEscapeLimbo = canEscapeLimbo;
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 relativeVelocity, Location location2) {
        if (!ModDimensions.isPocketDimension(entity.m_9236_()) && !ModDimensions.isLimboDimension(entity.m_9236_())) {
            return false;
        }
        if (ModDimensions.isLimboDimension(entity.m_9236_()) && !this.canEscapeLimbo) {
            return false;
        }
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        if (entity instanceof ServerPlayer) {
            Location destLoc;
            ServerLevel level;
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel destLevel = null;
            BlockPos destPos = null;
            if (DimensionalDoors.getConfig().getLimboConfig().tryPlayerBedSpawn && (level = DimensionalDoors.getWorld((ResourceKey<Level>)player.m_8963_())) != null) {
                destLevel = level;
                destPos = player.m_8961_();
            }
            if (destLevel == null) {
                ServerLevel level2;
                ResourceKey<Level> targetWorld = DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld;
                destLevel = DimensionalDoors.getServer().m_129783_();
                if (targetWorld != null && (level2 = DimensionalDoors.getWorld(targetWorld)) != null) {
                    destLevel = level2;
                }
                destPos = DimensionalDoors.getConfig().getLimboConfig().defaultToWorldSpawn ? destLevel.m_220360_() : player.m_20183_();
            }
            if ((destLoc = EscapeTarget.randomizeLimboReturn(destLevel, destPos, DimensionalDoors.getConfig().getLimboConfig().limboReturnDistanceMin, DimensionalDoors.getConfig().getLimboConfig().limboReturnDistanceMax)) != null && this.canEscapeLimbo) {
                Location location = destLoc;
                ServerLevel level3 = location.getWorld();
                entity = TeleportUtil.teleport(entity, (Level)level3, location.getBlockPos(), relativeAngle, relativeVelocity);
                entity.f_19789_ = -500.0f;
                level3.m_46597_(location.getBlockPos(), Blocks.f_50016_.m_49966_());
                level3.m_46597_(location.getBlockPos().m_7918_(0, 1, 0), Blocks.f_50016_.m_49966_());
                if (DimensionalDoors.getConfig().getLimboConfig().decaySurroundings) {
                    RandomSource random = RandomSource.m_216327_();
                    BlockPos.m_121925_((BlockPos)location.pos.m_7918_(0, -3, 0), (int)3, (int)2, (int)3).forEach(pos1 -> {
                        if (random.m_188501_() < 1.0f / (float)location.pos.m_123331_((Vec3i)pos1) * DimensionalDoors.getConfig().getLimboConfig().limboBlocksCorruptingExitWorldAmount) {
                            Block block = level3.m_8055_(pos1).m_60734_();
                            if (UnravelUtil.unravelBlocksMap.containsKey(block)) {
                                level3.m_46597_(pos1, UnravelUtil.unravelBlocksMap.get(block).m_49966_());
                            } else if (UnravelUtil.whitelistedBlocksForLimboRemoval.contains(block)) {
                                level3.m_46597_(pos1, ((Block)ModBlocks.UNRAVELLED_FABRIC.get()).m_49966_());
                            }
                        }
                    });
                }
            } else {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.rift_has_closed"));
                }
                if (ModDimensions.LIMBO_DIMENSION != null) {
                    entity = TeleportUtil.teleport(entity, (Level)ModDimensions.LIMBO_DIMENSION, new BlockPos(this.location.getX(), this.location.getY(), this.location.getZ()), relativeAngle, relativeVelocity);
                    entity.f_19789_ = -500.0f;
                }
            }
            return true;
        }
        return false;
    }

    public VirtualTarget.VirtualTargetType getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.ESCAPE.get();
    }

    @Override
    public VirtualTarget copy() {
        return new EscapeTarget(this.canEscapeLimbo);
    }

    public static Location randomizeLimboReturn(ServerLevel level, BlockPos pos, int minRange, int maxRange) {
        if (level == null || pos == null) {
            return null;
        }
        if (minRange == 0 && maxRange == 0) {
            return new Location(level, pos);
        }
        return new Location(level, Location.getHeightmapPosSafe(level, EscapeTarget.randomizeCoord(pos.m_123341_(), minRange, maxRange), EscapeTarget.randomizeCoord(pos.m_123343_(), minRange, maxRange)));
    }

    public static int randomizeCoord(int coord, int minRange, int maxRange) {
        Random random = new Random();
        if (minRange > maxRange) {
            throw new IllegalArgumentException("minRange cannot be greater than maxRange");
        }
        int offset = minRange + random.nextInt(maxRange - minRange + 1);
        boolean isPositive = random.nextBoolean();
        return isPositive ? coord + offset : coord - offset;
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canEscapeLimbo").forGetter(target -> target.canEscapeLimbo)).apply((Applicative)instance, EscapeTarget::new));
    }
}

