/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.Objects;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.BlankChunkGenerator;

public final class ModDimensions {
    public static final ResourceKey<Level> LIMBO = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("limbo"));
    public static final ResourceKey<Level> PERSONAL = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("personal_pockets"));
    public static final ResourceKey<Level> PUBLIC = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("public_pockets"));
    public static final ResourceKey<Level> DUNGEON = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DimensionalDoors.id("dungeon_pockets"));
    public static final ResourceKey<LevelStem> LIMBO_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)DimensionalDoors.id("limbo"));
    public static final ResourceKey<LevelStem> PERSONAL_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)DimensionalDoors.id("person"));
    public static final ResourceKey<LevelStem> PUBLIC_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)DimensionalDoors.id("public"));
    public static final ResourceKey<LevelStem> DUNGEON_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)DimensionalDoors.id("dungeon"));
    public static final ResourceKey<DimensionType> LIMBO_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)DimensionalDoors.id("limbo"));
    public static final ResourceKey<DimensionType> POCKET_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)DimensionalDoors.id("pocket"));
    public static DimensionType LIMBO_TYPE;
    public static DimensionType POCKET_TYPE;
    public static ServerLevel LIMBO_DIMENSION;
    public static ServerLevel PERSONAL_POCKET_DIMENSION;
    public static ServerLevel PUBLIC_POCKET_DIMENSION;
    public static ServerLevel DUNGEON_POCKET_DIMENSION;

    public static boolean isPocketDimension(Level world) {
        return ModDimensions.isPocketDimension((ResourceKey<Level>)world.m_46472_());
    }

    public static boolean isPrivatePocketDimension(Level world) {
        return world != null && world == PERSONAL_POCKET_DIMENSION;
    }

    public static boolean isPocketDimension(ResourceKey<Level> type) {
        return Objects.equals(type, PERSONAL) || Objects.equals(type, PUBLIC) || Objects.equals(type, DUNGEON);
    }

    public static boolean isDungeonDimension(ResourceKey<Level> type) {
        return Objects.equals(type, PERSONAL) || Objects.equals(type, PUBLIC) || Objects.equals(type, DUNGEON);
    }

    public static boolean isLimboDimension(Level world) {
        return world != null && world.m_46472_().equals(LIMBO);
    }

    public static void init() {
        LifecycleEvent.SERVER_STARTED.register(server -> {
            LIMBO_TYPE = (DimensionType)server.m_206579_().m_175515_(Registries.f_256787_).m_6246_(LIMBO_TYPE_KEY);
            POCKET_TYPE = (DimensionType)server.m_206579_().m_175515_(Registries.f_256787_).m_6246_(POCKET_TYPE_KEY);
            LIMBO_DIMENSION = server.m_129880_(LIMBO);
            PERSONAL_POCKET_DIMENSION = server.m_129880_(PERSONAL);
            PUBLIC_POCKET_DIMENSION = server.m_129880_(PUBLIC);
            DUNGEON_POCKET_DIMENSION = server.m_129880_(DUNGEON);
        });
        DeferredRegister deffered = DeferredRegister.create((String)"dimdoors", (ResourceKey)Registries.f_256783_);
        deffered.register("blank", () -> BlankChunkGenerator.CODEC);
        deffered.register();
    }

    public static void bootstrap(BootstapContext<DimensionType> entries) {
        entries.m_255272_(LIMBO_TYPE_KEY, (Object)new DimensionType(OptionalLong.of(6000L), true, false, false, false, 4.0, false, true, 0, 256, 256, BlockTags.f_13058_, DimensionalDoors.id("limbo"), 0.1f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0)));
        entries.m_255272_(POCKET_TYPE_KEY, (Object)new DimensionType(OptionalLong.of(6000L), true, false, false, false, 4.0, false, true, 0, 256, 256, BlockTags.f_13058_, DimensionalDoors.id("dungeon"), 0.1f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 0)));
    }

    private static LevelStem createPocketStem(Holder<DimensionType> dimensionType, Holder<Biome> biome) {
        return new LevelStem(dimensionType, (ChunkGenerator)BlankChunkGenerator.of((BiomeSource)new FixedBiomeSource(biome)));
    }
}

