/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.conditions;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayCondition;
import org.dimdev.dimdoors.world.decay.DecaySource;

public abstract class GenericDecayCondition<T>
implements DecayCondition {
    private final TagOrElementLocation<T> tagOrElementLocation;
    private final boolean invert;

    public static <T extends GenericDecayCondition<?>, V> Codec<T> createCodec(BiFunction<TagOrElementLocation<V>, Boolean, T> function, ResourceKey<Registry<V>> key) {
        Codec codec = Codec.STRING.comapFlatMap(string -> string.startsWith("#") ? ResourceLocation.m_135837_((String)string.substring(1)).map(resourceLocation -> new TagOrElementLocation((ResourceLocation)resourceLocation, true, key)) : ResourceLocation.m_135837_((String)string).map(resourceLocation -> new TagOrElementLocation((ResourceLocation)resourceLocation, false, key)), TagOrElementLocation::decoratedId);
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("entry").forGetter(t -> t.getTagOrElementLocation()), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(GenericDecayCondition::invert)).apply((Applicative)instance, function));
    }

    public GenericDecayCondition(TagOrElementLocation<T> tagOrElementLocation, boolean invert) {
        this.tagOrElementLocation = tagOrElementLocation;
        this.invert = invert;
    }

    public TagOrElementLocation<T> getTagOrElementLocation() {
        return this.tagOrElementLocation;
    }

    @Override
    public boolean test(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid, DecaySource source) {
        return this.tagOrElementLocation.test(this.getHolder(world, pos, origin, targetBlock, targetFluid, source));
    }

    public abstract Holder<T> getHolder(Level var1, BlockPos var2, BlockState var3, BlockState var4, FluidState var5, DecaySource var6);

    public boolean invert() {
        return this.invert;
    }

    public static final class TagOrElementLocation<T> {
        private TagKey<T> tag;
        private ResourceKey<T> key;

        public static <T> TagOrElementLocation<T> of(TagKey<T> tag, ResourceKey<Registry<T>> registry) {
            return new TagOrElementLocation<T>(tag.f_203868_(), true, registry);
        }

        public static <T> TagOrElementLocation<T> of(ResourceKey<T> tag, ResourceKey<Registry<T>> registry) {
            return new TagOrElementLocation<T>(tag.m_135782_(), false, registry);
        }

        public TagOrElementLocation(ResourceLocation id, boolean tag, ResourceKey<Registry<T>> registryResourceKey) {
            if (tag) {
                this.tag = TagKey.m_203882_(registryResourceKey, (ResourceLocation)id);
            } else {
                this.key = ResourceKey.m_135785_(registryResourceKey, (ResourceLocation)id);
            }
        }

        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag != null ? "#" + String.valueOf(this.tag.f_203868_()) : this.key.m_135782_().toString();
        }

        public boolean test(Holder<T> holder) {
            return this.tag != null && holder.m_203656_(this.tag) || holder.m_203565_(this.key);
        }

        public Set<ResourceKey<T>> getValues(Registry<T> registry) {
            return this.key != null ? Set.of(this.key) : Streams.stream((Iterable)registry.m_206058_(this.tag)).map(Holder::m_203543_).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
    }
}

