/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.results;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.world.decay.DecayResultType;
import org.dimdev.dimdoors.world.decay.DecaySource;
import org.dimdev.dimdoors.world.decay.results.BlockDecayResult;

public class BlockDecayImplResult
extends BlockDecayResult<BlockDecayImplResult> {
    public static final Codec<BlockDecayImplResult> CODEC = RecordCodecBuilder.create(instance -> BlockDecayImplResult.blockDecayCodec(instance).apply((Applicative)instance, BlockDecayImplResult::new));
    public static final String KEY = "block";

    public BlockDecayImplResult(int entropy, float worldThreadChance, Block block) {
        super(entropy, worldThreadChance, block);
    }

    @Override
    public DecayResultType<BlockDecayImplResult> getType() {
        return (DecayResultType)DecayResultType.BLOCK_RESULT_TYPE.get();
    }

    @Override
    public int process(Level world, BlockPos pos, BlockState origin, BlockState target, FluidState targetFluid, DecaySource source) {
        BlockState newState = UnravelUtil.copyState(this.block, target);
        if (target.m_60734_() instanceof DoublePlantBlock) {
            pos = target.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? pos.m_7494_() : pos;
        }
        world.m_46597_(pos, newState);
        return this.entropy;
    }
}

