/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.results;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayResultType;
import org.dimdev.dimdoors.world.decay.DecaySource;
import org.dimdev.dimdoors.world.decay.results.BlockDecayResult;

public class DoubleBlockDecayResult
extends BlockDecayResult<DoubleBlockDecayResult> {
    public static final Codec<DoubleBlockDecayResult> CODEC = RecordCodecBuilder.create(instance -> DoubleBlockDecayResult.blockDecayCodec(instance).apply((Applicative)instance, DoubleBlockDecayResult::new));
    public static final String KEY = "double_block";

    public DoubleBlockDecayResult(int entropy, float worldThreadChance, Block block) {
        super(entropy, worldThreadChance, block);
    }

    @Override
    public DecayResultType<DoubleBlockDecayResult> getType() {
        return (DecayResultType)DecayResultType.DOUBLE_BLOCK_RESULT_TYPE.get();
    }

    @Override
    public int process(Level world, BlockPos pos, BlockState origin, BlockState target, FluidState targetFluid, DecaySource source) {
        if (target.m_60734_() instanceof DoorBlock) {
            BlockPos otherPos = target.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
            Direction facing = (Direction)target.m_61143_((Property)DoorBlock.f_52726_);
            if (((Boolean)target.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                facing = target.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT ? facing.m_122428_() : facing.m_122427_();
            }
            BlockState newState = (BlockState)((BlockState)this.block.m_49966_().m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)facing);
            world.m_46597_(pos, newState);
            world.m_46597_(otherPos, newState);
            return this.entropy;
        }
        if (target.m_60734_() instanceof BedBlock) {
            BlockPos otherPos = pos.m_121945_(BedBlock.m_49557_((BlockState)target));
            BlockState newState = this.block.m_49966_();
            world.m_46597_(pos, newState);
            world.m_46597_(otherPos, newState);
        }
        return 0;
    }

    @Override
    public Object produces(Object prior) {
        return new ItemStack((ItemLike)this.block, 2);
    }
}

