/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay.results;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayResult;
import org.dimdev.dimdoors.world.decay.DecayResultType;
import org.dimdev.dimdoors.world.decay.DecaySource;

public class FluidDecayResult
implements DecayResult {
    public static final Codec<FluidDecayResult> CODEC = RecordCodecBuilder.create(instance -> DecayResult.entropyCodec(instance).and((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf(KEY).forGetter(blockDecayResult -> blockDecayResult.fluid)).apply((Applicative)instance, FluidDecayResult::new));
    public static final String KEY = "fluid";
    private final float worldThreadChance;
    protected Fluid fluid;
    protected int entropy;

    public FluidDecayResult(int entropy, float worldThreadChance, Fluid fluid) {
        this.entropy = entropy;
        this.worldThreadChance = worldThreadChance;
        this.fluid = fluid;
    }

    public DecayResultType<FluidDecayResult> getType() {
        return (DecayResultType)DecayResultType.FLUID_RESULT_TYPE.get();
    }

    @Override
    public int entropy() {
        return this.entropy;
    }

    @Override
    public float worldThreadChance() {
        return this.worldThreadChance;
    }

    @Override
    public int process(Level world, BlockPos pos, BlockState origin, BlockState target, FluidState targetFluid, DecaySource source) {
        BlockState newState = this.fluid.m_76145_().m_76188_();
        world.m_46597_(pos, newState);
        return this.entropy;
    }

    @Override
    public Object produces(Object prior) {
        return FluidStack.create((Fluid)this.fluid, (long)1000L);
    }

    private static <T extends Comparable<T>> FluidState transferProperty(FluidState from, FluidState to, Property<T> property) {
        return (FluidState)to.m_61124_(property, from.m_61143_(property));
    }
}

