/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.level.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.rift.registry.RiftRegistry;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.RiftSchemas;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.PrivateRegistry;

public class DimensionalRegistry {
    public static final int RIFT_DATA_VERSION = 1;
    private static Map<ResourceKey<Level>, PocketDirectory> pocketRegistry = new HashMap<ResourceKey<Level>, PocketDirectory>();
    private static RiftRegistry riftRegistry = new RiftRegistry();
    private static PrivateRegistry privateRegistry = new PrivateRegistry();

    public static void readFromNbt(CompoundTag nbt) {
        int riftDataVersion = nbt.m_128451_("RiftDataVersion");
        if (riftDataVersion < 1) {
            nbt = RiftSchemas.update(riftDataVersion, nbt);
        } else if (1 < riftDataVersion) {
            throw new UnsupportedOperationException("Downgrading is not supported!");
        }
        CompoundTag pocketRegistryNbt = nbt.m_128469_("pocket_registry");
        CompletableFuture<Map> futurePocketRegistry = CompletableFuture.supplyAsync(() -> ((Stream)pocketRegistryNbt.m_128431_().stream().map(key -> {
            CompoundTag pocketDirectoryNbt = pocketRegistryNbt.m_128469_(key);
            return CompletableFuture.supplyAsync(() -> new Pair((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)key)), (Object)PocketDirectory.readFromNbt(key, pocketDirectoryNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond)));
        CompoundTag privateRegistryNbt = nbt.m_128469_("private_registry");
        CompletableFuture<PrivateRegistry> futurePrivateRegistry = CompletableFuture.supplyAsync(() -> {
            PrivateRegistry privateRegistry = new PrivateRegistry();
            privateRegistry.fromNbt(privateRegistryNbt);
            return privateRegistry;
        });
        pocketRegistry = futurePocketRegistry.join();
        CompoundTag riftRegistryNbt = nbt.m_128469_("rift_registry");
        CompletableFuture<RiftRegistry> futureRiftRegistry = CompletableFuture.supplyAsync(() -> RiftRegistry.fromNbt(pocketRegistry, riftRegistryNbt));
        riftRegistry = futureRiftRegistry.join();
        privateRegistry = futurePrivateRegistry.join();
    }

    public static void writeToNbt(CompoundTag nbt) {
        CompletableFuture<Tag> futurePocketRegistryNbt = StreamUtils.supplyAsync(() -> {
            ArrayList futurePocketRegistryNbts = new ArrayList();
            pocketRegistry.forEach((key, value) -> futurePocketRegistryNbts.add(CompletableFuture.supplyAsync(() -> new Pair((Object)key.m_135782_().toString(), (Object)value.writeToNbt()))));
            CompoundTag pocketRegistryNbt = new CompoundTag();
            ((Stream)futurePocketRegistryNbts.parallelStream().unordered()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond)).forEach((arg_0, arg_1) -> ((CompoundTag)pocketRegistryNbt).m_128365_(arg_0, arg_1));
            return pocketRegistryNbt;
        });
        CompletableFuture<Tag> futureRiftRegistryNbt = StreamUtils.supplyAsync(riftRegistry::toNbt);
        CompletableFuture<Tag> futurePrivateRegistryNbt = CompletableFuture.supplyAsync(() -> privateRegistry.toNbt(new CompoundTag()));
        nbt.m_128365_("pocket_registry", futurePocketRegistryNbt.join());
        nbt.m_128365_("rift_registry", futureRiftRegistryNbt.join());
        nbt.m_128365_("private_registry", futurePrivateRegistryNbt.join());
        nbt.m_128405_("RiftDataVersion", 1);
    }

    public static RiftRegistry getRiftRegistry() {
        return riftRegistry;
    }

    public static PrivateRegistry getPrivateRegistry() {
        return privateRegistry;
    }

    public static PocketDirectory getPocketDirectory(ResourceKey<Level> key) {
        if (!ModDimensions.isPocketDimension(key)) {
            throw new UnsupportedOperationException("PocketRegistry is only available for pocket dimensions!");
        }
        return pocketRegistry.computeIfAbsent(key, PocketDirectory::new);
    }

    public static boolean isValidWorld(Level level) {
        return level != null && level.m_46472_() != null && level.m_46472_().equals(Level.f_46428_);
    }
}

