/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.world.level.component.ChunkLazilyGeneratedComponent;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class LazyGenerationPocket
extends Pocket {
    public static String KEY = "lazy_gen_pocket";
    private LazyPocketGenerator generator;
    private int toBeGennedChunkCount = 0;

    public void chunkLoaded(LevelChunk chunk) {
        if (this.isDoneGenerating()) {
            return;
        }
        ChunkLazilyGeneratedComponent lazyGenned = ChunkLazilyGeneratedComponent.get(chunk);
        if (lazyGenned.hasBeenLazyGenned()) {
            return;
        }
        BoundingBox chunkBox = BlockBoxUtil.getBox((ChunkAccess)chunk);
        if (!chunkBox.m_71049_(this.getBox())) {
            return;
        }
        this.generator.generateChunk(this, chunk);
        lazyGenned.setGenned();
        --this.toBeGennedChunkCount;
        if (this.isDoneGenerating()) {
            this.generator = null;
        }
    }

    public boolean isDoneGenerating() {
        return this.toBeGennedChunkCount == 0;
    }

    public void attachGenerator(LazyPocketGenerator generator) {
        this.generator = generator;
    }

    public void init() {
        BoundingBox box = this.getBox();
        this.toBeGennedChunkCount = (Math.floorDiv(box.m_162399_(), 16) - Math.floorDiv(box.m_162395_(), 16) + 1) * (Math.floorDiv(box.m_162401_(), 16) - Math.floorDiv(box.m_162398_(), 16) + 1);
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        super.toNbt(nbt);
        if (this.generator != null) {
            nbt.m_128365_("generator", this.generator.toNbt(new CompoundTag()));
        }
        if (this.toBeGennedChunkCount > 0) {
            nbt.m_128405_("to_be_genned_chunks", this.toBeGennedChunkCount);
        }
        return nbt;
    }

    @Override
    public AbstractPocket.AbstractPocketType<?> getType() {
        return (AbstractPocket.AbstractPocketType)AbstractPocket.AbstractPocketType.LAZY_GENERATION_POCKET.get();
    }

    public static String getKEY() {
        return KEY;
    }

    @Override
    public Pocket fromNbt(CompoundTag nbt) {
        super.fromNbt(nbt);
        if (nbt.m_128425_("generator", 10)) {
            this.generator = (LazyPocketGenerator)PocketGenerator.deserialize(nbt.m_128469_("generator"));
        }
        if (nbt.m_128425_("to_be_genned_chunks", 3)) {
            this.toBeGennedChunkCount = nbt.m_128451_("to_be_genned_chunks");
        }
        return this;
    }

    @Override
    public Map<BlockPos, BlockEntity> getBlockEntities() {
        return super.getBlockEntities();
    }

    public static LazyGenerationPocketBuilder<?, LazyGenerationPocket> builderLazyGenerationPocket() {
        return new LazyGenerationPocketBuilder((AbstractPocket.AbstractPocketType)AbstractPocket.AbstractPocketType.LAZY_GENERATION_POCKET.get());
    }

    public static class LazyGenerationPocketBuilder<P extends LazyGenerationPocketBuilder<P, T>, T extends LazyGenerationPocket>
    extends Pocket.PocketBuilder<P, T> {
        protected LazyGenerationPocketBuilder(AbstractPocket.AbstractPocketType<T> type) {
            super(type);
        }
    }
}

