/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.joml.Matrix4dc;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.shadow.zF;
import org.valkyrienskies.core.impl.util.serialization.DeltaIgnore;
import org.valkyrienskies.core.impl.util.serialization.PacketIgnore;
import org.valkyrienskies.core.util.AABBdUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\bS\u0010TJ\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJO\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR,\u0010(\u001a\u00060!j\u0002`\"2\n\u0010#\u001a\u00060!j\u0002`\"8W@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0018\u00100\u001a\u00060,j\u0002`-8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\u0002018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R$\u00107\u001a\u0002052\u0006\u00106\u001a\u0002058\u0017@RX\u0097\u000e\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0016\u0010>\u001a\u0004\u0018\u00010;8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010B\u001a\u00020?8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0016\u0010D\u001a\u0004\u0018\u00010!8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010%R*\u0010F\u001a\u0002052\u0006\u0010E\u001a\u0002058\u0017@WX\u0097\u000e\u00a2\u0006\u0012\n\u0004\bF\u00108\u001a\u0004\bG\u0010:\"\u0004\bH\u0010IR\u0014\u0010K\u001a\u0002018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u00103R$\u0010M\u001a\u00020L2\u0006\u00106\u001a\u00020L8\u0017@RX\u0097\u000e\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u0014\u0010R\u001a\u00020?8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010A"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/AbstractUnloadedShip;", "Lorg/valkyrienskies/core/impl/shadow/zF;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "updatePrevTickShipTransform", "()V", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "getActiveChunksSet", "()Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "activeChunksSet", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "getChunkClaim", "()Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "value", "getChunkClaimDimension", "()Ljava/lang/String;", "setChunkClaimDimension", "(Ljava/lang/String;)V", "chunkClaimDimension", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "data", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "getId", "()J", "id", "Lorg/joml/Vector3dc;", "getOmega", "()Lorg/joml/Vector3dc;", "omega", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "p0", "prevTickTransform", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getPrevTickTransform", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/primitives/AABBic;", "getShipAABB", "()Lorg/joml/primitives/AABBic;", "shipAABB", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "getSlug", "slug", "shipTransform", "transform", "getTransform", "setTransform", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;)V", "getVelocity", "velocity", "Lorg/joml/primitives/AABBdc;", "worldAABB", "Lorg/joml/primitives/AABBdc;", "getWorldAABB", "()Lorg/joml/primitives/AABBdc;", "getWorldToShip", "worldToShip", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;)V"})
public final class AbstractUnloadedShip
implements zF {
    private final ShipDataCommon data;
    @DeltaIgnore
    private ShipTransform transform;
    @PacketIgnore
    private ShipTransform prevTickTransform;
    @DeltaIgnore
    private AABBdc worldAABB;

    public AbstractUnloadedShip(ShipDataCommon data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"");
        this.data = data;
        this.transform = this.getShipTransform();
        this.prevTickTransform = this.data.getPrevTickTransform();
        this.worldAABB = this.data.getWorldAABB();
    }

    @JvmName(name="getVelocity")
    public Vector3dc getVelocity() {
        return this.data.getPhysicsData().getLinearVelocity();
    }

    @JvmName(name="getOmega")
    public Vector3dc getOmega() {
        return this.data.getPhysicsData().getAngularVelocity();
    }

    @JvmName(name="getActiveChunksSet")
    public IShipActiveChunksSet getActiveChunksSet() {
        return this.data.getActiveChunksSet();
    }

    @JvmName(name="getId")
    public long getId() {
        return this.data.getId();
    }

    @JvmName(name="getSlug")
    public String getSlug() {
        return this.data.getSlug();
    }

    @JvmName(name="getTransform")
    public ShipTransform getTransform() {
        return this.transform;
    }

    @JvmName(name="setTransform")
    public void setTransform(ShipTransform shipTransform) {
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"");
        this.transform = shipTransform;
        AABBic aABBic = this.getShipAABB();
        AABBd aABBd = aABBic != null && (aABBic = AABBdUtilKt.toAABBd((AABBic)aABBic, (AABBd)new AABBd())) != null ? aABBic.transform(shipTransform.getShipToWorld(), new AABBd()) : null;
        this.worldAABB = aABBd == null ? shipTransform.createEmptyAABB() : (AABBdc)aABBd;
    }

    @JvmName(name="getPrevTickTransform")
    public ShipTransform getPrevTickTransform() {
        return this.prevTickTransform;
    }

    @JvmName(name="getChunkClaim")
    public ChunkClaim getChunkClaim() {
        return this.data.getChunkClaim();
    }

    @JvmName(name="getChunkClaimDimension")
    public String getChunkClaimDimension() {
        return this.data.getChunkClaimDimension();
    }

    @JvmName(name="setChunkClaimDimension")
    public void setChunkClaimDimension(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        this.data.setChunkClaimDimension(value);
    }

    @JvmName(name="getWorldAABB")
    public AABBdc getWorldAABB() {
        return this.worldAABB;
    }

    @JvmName(name="getShipAABB")
    public AABBic getShipAABB() {
        return this.data.getShipAABB();
    }

    public final void updatePrevTickShipTransform() {
        this.prevTickTransform = this.getTransform();
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, BlockType oldBlockType, BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"");
        if (!this.getChunkClaim().contains(posX >> 4, posZ >> 4)) {
            boolean bl2 = false;
            String string = "Block at <" + posX + ", " + posY + ", " + posZ + "> is not in the chunk claim belonging to " + this;
            throw new IllegalArgumentException(string.toString());
        }
        this.getActiveChunksSet().add(posX >> 4, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) - 1, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) + 1, posZ >> 4);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) - 1);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) + 1);
    }

    @JvmName(name="getShipToWorld")
    public Matrix4dc getShipToWorld() {
        return this.getTransform().getShipToWorld();
    }

    @JvmName(name="getWorldToShip")
    public Matrix4dc getWorldToShip() {
        return this.getTransform().getWorldToShip();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other);
        ShipDataCommon cfr_ignored_0 = (ShipDataCommon)other;
        return this.getId() == ((ShipDataCommon)other).getId();
    }

    public int hashCode() {
        return Long.hashCode(this.getId());
    }
}

