/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.CollisionShapeReference;
import org.valkyrienskies.physics_api.CompoundShapeReference;
import org.valkyrienskies.physics_api.NextPoseVelFunction;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.ShapeInUseException;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api_krunch.KrunchShapeReference;
import org.valkyrienskies.physics_api_krunch.PoseVelEncoder;

class KrunchNativeCompoundShapeReference
implements CompoundShapeReference,
KrunchShapeReference {
    private long shapeAddress;
    private static final long DELETED_SHAPE_ADDRESS = -1L;
    private final Int2ObjectMap<CompoundShapeReference.CompoundShapeSegmentReference> segments = new Int2ObjectOpenHashMap();

    protected KrunchNativeCompoundShapeReference(long shapeAddress) {
        this.shapeAddress = shapeAddress;
    }

    @Override
    public void close() {
        this.ensureNotDeleted();
        boolean deleteSuccessful = KrunchNativeCompoundShapeReference.deleteCompoundShape(this.shapeAddress);
        if (!deleteSuccessful) {
            throw new ShapeInUseException("Delete compound shape failed! This shape is currently in use!");
        }
        this.shapeAddress = -1L;
    }

    protected void finalize() {
        if (this.shapeAddress != -1L) {
            this.close();
        }
        this.shapeAddress = -1L;
    }

    @Override
    public long getShapeShapeAddress() {
        this.ensureNotDeleted();
        return this.shapeAddress;
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.shapeAddress == -1L;
    }

    @Override
    @NotNull
    public Map<Integer, CompoundShapeReference.CompoundShapeSegmentReference> getSegments() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return this.segments;
    }

    @Override
    public boolean deleteSegment(int segmentId) {
        boolean javaDeleteSuccess;
        this.ensureNotDeleted();
        boolean bl2 = javaDeleteSuccess = this.segments.remove(segmentId) != null;
        if (!javaDeleteSuccess) {
            return false;
        }
        return KrunchNativeCompoundShapeReference.deleteSegmentNative(this.getShapeShapeAddress(), segmentId);
    }

    @Override
    @NotNull
    public CompoundShapeReference.CompoundShapeSegmentReference makeNewSegment(int segmentId, @NotNull CollisionShapeReference collisionShapeReference, @NotNull PoseVel poseVel, double collisionShapeScaling, @NotNull Vector3dc collisionShapeOffset, @Nullable NextPoseVelFunction nextPoseVelFunction) {
        this.ensureNotDeleted();
        if (this.segments.containsKey(segmentId)) {
            throw new IllegalArgumentException("Segment with id " + segmentId + " already exists!");
        }
        KrunchNativeCompoundShapeReference.createSegmentNative(this.getShapeShapeAddress(), segmentId);
        KrunchNativeCompoundShapeSegmentReference segmentReference = new KrunchNativeCompoundShapeSegmentReference(segmentId, collisionShapeReference);
        KrunchNativeCompoundShapeReference.setSegmentCollisionShape(this.getShapeShapeAddress(), segmentId, ((KrunchShapeReference)((Object)collisionShapeReference)).getShapeShapeAddress());
        segmentReference.setPoseVel(poseVel);
        segmentReference.setCollisionShapeScaling(collisionShapeScaling);
        segmentReference.setCollisionShapeOffset(collisionShapeOffset);
        this.segments.put(segmentId, (Object)segmentReference);
        return segmentReference;
    }

    private void ensureNotDeleted() {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    private static native boolean createSegmentNative(long var0, int var2);

    private static native boolean deleteSegmentNative(long var0, int var2);

    private static native boolean setSegmentCollisionShape(long var0, int var2, long var3);

    private static native boolean getCollisionShapeOffsetNative(long var0, int var2, double[] var3);

    private static native boolean setCollisionShapeOffsetNative(long var0, int var2, double[] var3);

    private static native double getCollisionShapeScalingNative(long var0, int var2);

    private static native double setCollisionShapeScalingNative(long var0, int var2, double var3);

    private static native void getPoseVelNative(long var0, int var2, @NotNull byte[] var3);

    private static native void setPoseVelNative(long var0, int var2, @NotNull byte[] var3);

    private static native boolean deleteCompoundShape(long var0);

    private class KrunchNativeCompoundShapeSegmentReference
    implements CompoundShapeReference.CompoundShapeSegmentReference {
        private final int segmentId;
        @NotNull
        private CollisionShapeReference collisionShapeReference;
        @Nullable
        private NextPoseVelFunction nextPoseVelFunction;

        private KrunchNativeCompoundShapeSegmentReference(@NotNull int segmentId, CollisionShapeReference collisionShapeReference) {
            this.segmentId = segmentId;
            this.collisionShapeReference = collisionShapeReference;
            this.nextPoseVelFunction = null;
        }

        @Override
        @NotNull
        public CollisionShapeReference getCollisionShape() {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            return this.collisionShapeReference;
        }

        @Override
        public void setCollisionShape(@NotNull CollisionShapeReference collisionShapeReference) {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            this.collisionShapeReference = collisionShapeReference;
            KrunchNativeCompoundShapeReference.setSegmentCollisionShape(KrunchNativeCompoundShapeReference.this.getShapeShapeAddress(), this.segmentId, ((KrunchShapeReference)((Object)collisionShapeReference)).getShapeShapeAddress());
        }

        @Override
        @NotNull
        public Vector3dc getCollisionShapeOffset() {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            double[] offset = new double[3];
            boolean success = KrunchNativeCompoundShapeReference.getCollisionShapeOffsetNative(KrunchNativeCompoundShapeReference.this.shapeAddress, this.segmentId, offset);
            if (!success) {
                throw new IllegalStateException("Call to getCollisionShapeOffset() failed");
            }
            return new Vector3d(offset[0], offset[1], offset[2]);
        }

        @Override
        public void setCollisionShapeOffset(@NotNull Vector3dc offset) {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            boolean success = KrunchNativeCompoundShapeReference.setCollisionShapeOffsetNative(KrunchNativeCompoundShapeReference.this.shapeAddress, this.segmentId, new double[]{offset.x(), offset.y(), offset.z()});
            if (!success) {
                throw new IllegalStateException("Call to setCollisionShapeOffset() failed");
            }
        }

        @Override
        public double getCollisionShapeScaling() {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            return KrunchNativeCompoundShapeReference.getCollisionShapeScalingNative(KrunchNativeCompoundShapeReference.this.shapeAddress, this.segmentId);
        }

        @Override
        public void setCollisionShapeScaling(double scaling) {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            KrunchNativeCompoundShapeReference.setCollisionShapeScalingNative(KrunchNativeCompoundShapeReference.this.shapeAddress, this.segmentId, scaling);
        }

        @Override
        @Nullable
        public NextPoseVelFunction getNextPoseVelFunction() {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            return this.nextPoseVelFunction;
        }

        @Override
        public void setNextPoseVelFunction(@Nullable NextPoseVelFunction nextPoseVelFunction) {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            this.nextPoseVelFunction = nextPoseVelFunction;
        }

        @Override
        @NotNull
        public PoseVel getPoseVel() {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            byte[] encoded = new byte[104];
            KrunchNativeCompoundShapeReference.getPoseVelNative(KrunchNativeCompoundShapeReference.this.shapeAddress, this.segmentId, encoded);
            return PoseVelEncoder.decodePoseVel(encoded);
        }

        @Override
        public void setPoseVel(@NotNull PoseVel poseVel) {
            KrunchNativeCompoundShapeReference.this.ensureNotDeleted();
            byte[] encoded = PoseVelEncoder.encodePoseVel(poseVel);
            KrunchNativeCompoundShapeReference.setPoseVelNative(KrunchNativeCompoundShapeReference.this.shapeAddress, this.segmentId, encoded);
        }
    }
}

