/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments;

import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.modhelper.ModHelper;
import com.majruszlibrary.registry.Custom;
import com.majruszlibrary.registry.RegistryGroup;
import com.majruszlibrary.registry.RegistryObject;
import com.majruszsenchantments.curses.BreakingCurse;
import com.majruszsenchantments.curses.CorrosionCurse;
import com.majruszsenchantments.curses.FatigueCurse;
import com.majruszsenchantments.curses.IncompatibilityCurse;
import com.majruszsenchantments.curses.SlipperyCurse;
import com.majruszsenchantments.data.Config;
import com.majruszsenchantments.enchantments.DeathWishEnchantment;
import com.majruszsenchantments.enchantments.DodgeEnchantment;
import com.majruszsenchantments.enchantments.EnlightenmentEnchantment;
import com.majruszsenchantments.enchantments.FishingFanaticEnchantment;
import com.majruszsenchantments.enchantments.FuseCutterEnchantment;
import com.majruszsenchantments.enchantments.GoldFuelledEnchantment;
import com.majruszsenchantments.enchantments.HarvesterEnchantment;
import com.majruszsenchantments.enchantments.HorseFrostWalkerEnchantment;
import com.majruszsenchantments.enchantments.HorseProtectionEnchantment;
import com.majruszsenchantments.enchantments.HorseSwiftnessEnchantment;
import com.majruszsenchantments.enchantments.HunterEnchantment;
import com.majruszsenchantments.enchantments.ImmortalityEnchantment;
import com.majruszsenchantments.enchantments.LeechEnchantment;
import com.majruszsenchantments.enchantments.MagicProtectionEnchantment;
import com.majruszsenchantments.enchantments.MisanthropyEnchantment;
import com.majruszsenchantments.enchantments.RepulsionEnchantment;
import com.majruszsenchantments.enchantments.SixthSenseEnchantment;
import com.majruszsenchantments.enchantments.SmelterEnchantment;
import com.majruszsenchantments.enchantments.TelekinesisEnchantment;
import com.majruszsenchantments.particles.DodgeParticle;
import com.majruszsenchantments.particles.SmelterParticle;
import com.majruszsenchantments.particles.TelekinesisParticle;
import com.majruszsenchantments.particles.TelekinesisParticleType;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MajruszsEnchantments {
    public static final String MOD_ID = "majruszsenchantments";
    public static final ModHelper HELPER = ModHelper.create((String)"majruszsenchantments");
    public static final RegistryGroup<Enchantment> ENCHANTMENTS;
    public static final RegistryGroup<ParticleType<?>> PARTICLES;
    public static final RegistryObject<CustomEnchantment> DEATH_WISH;
    public static final RegistryObject<CustomEnchantment> DODGE;
    public static final RegistryObject<CustomEnchantment> ENLIGHTENMENT;
    public static final RegistryObject<CustomEnchantment> FISHING_FANATIC;
    public static final RegistryObject<CustomEnchantment> FUSE_CUTTER;
    public static final RegistryObject<CustomEnchantment> GOLD_FUELLED;
    public static final RegistryObject<CustomEnchantment> HARVESTER;
    public static final RegistryObject<CustomEnchantment> HORSE_FROST_WALKER;
    public static final RegistryObject<CustomEnchantment> HORSE_PROTECTION;
    public static final RegistryObject<CustomEnchantment> HORSE_SWIFTNESS;
    public static final RegistryObject<CustomEnchantment> HUNTER;
    public static final RegistryObject<CustomEnchantment> IMMORTALITY;
    public static final RegistryObject<CustomEnchantment> LEECH;
    public static final RegistryObject<CustomEnchantment> MAGIC_PROTECTION;
    public static final RegistryObject<CustomEnchantment> MISANTHROPY;
    public static final RegistryObject<CustomEnchantment> REPULSION;
    public static final RegistryObject<CustomEnchantment> SIXTH_SENSE;
    public static final RegistryObject<CustomEnchantment> SMELTER;
    public static final RegistryObject<CustomEnchantment> TELEKINESIS;
    public static final RegistryObject<CustomEnchantment> BREAKING;
    public static final RegistryObject<CustomEnchantment> CORROSION;
    public static final RegistryObject<CustomEnchantment> FATIGUE;
    public static final RegistryObject<CustomEnchantment> INCOMPATIBILITY;
    public static final RegistryObject<CustomEnchantment> SLIPPERY;
    public static final Predicate<ItemStack> IS_BOW_OR_CROSSBOW;
    public static final Predicate<ItemStack> IS_GOLDEN;
    public static final Predicate<ItemStack> IS_HORSE_ARMOR;
    public static final Predicate<ItemStack> IS_HOE;
    public static final Predicate<ItemStack> IS_MELEE_MINECRAFT;
    public static final Predicate<ItemStack> IS_MELEE;
    public static final Predicate<ItemStack> IS_SHIELD;
    public static final Predicate<ItemStack> IS_TOOL;
    public static final RegistryObject<SimpleParticleType> DODGE_PARTICLE;
    public static final RegistryObject<SimpleParticleType> SMELTER_PARTICLE;
    public static final RegistryObject<TelekinesisParticleType> TELEKINESIS_PARTICLE;

    private MajruszsEnchantments() {
    }

    static {
        HELPER.config(Config.class).autoSync().create();
        ENCHANTMENTS = HELPER.create(BuiltInRegistries.f_256876_);
        PARTICLES = HELPER.create(BuiltInRegistries.f_257034_);
        DEATH_WISH = ENCHANTMENTS.create("death_wish", DeathWishEnchantment::create);
        DODGE = ENCHANTMENTS.create("dodge", DodgeEnchantment::create);
        ENLIGHTENMENT = ENCHANTMENTS.create("enlightenment", EnlightenmentEnchantment::create);
        FISHING_FANATIC = ENCHANTMENTS.create("fishing_fanatic", FishingFanaticEnchantment::create);
        FUSE_CUTTER = ENCHANTMENTS.create("fuse_cutter", FuseCutterEnchantment::create);
        GOLD_FUELLED = ENCHANTMENTS.create("gold_fuelled", GoldFuelledEnchantment::create);
        HARVESTER = ENCHANTMENTS.create("harvester", HarvesterEnchantment::create);
        HORSE_FROST_WALKER = ENCHANTMENTS.create("horse_frost_walker", HorseFrostWalkerEnchantment::create);
        HORSE_PROTECTION = ENCHANTMENTS.create("horse_protection", HorseProtectionEnchantment::create);
        HORSE_SWIFTNESS = ENCHANTMENTS.create("horse_swiftness", HorseSwiftnessEnchantment::create);
        HUNTER = ENCHANTMENTS.create("hunter", HunterEnchantment::create);
        IMMORTALITY = ENCHANTMENTS.create("immortality", ImmortalityEnchantment::create);
        LEECH = ENCHANTMENTS.create("leech", LeechEnchantment::create);
        MAGIC_PROTECTION = ENCHANTMENTS.create("magic_protection", MagicProtectionEnchantment::create);
        MISANTHROPY = ENCHANTMENTS.create("misanthropy", MisanthropyEnchantment::create);
        REPULSION = ENCHANTMENTS.create("repulsion", RepulsionEnchantment::create);
        SIXTH_SENSE = ENCHANTMENTS.create("sixth_sense", SixthSenseEnchantment::create);
        SMELTER = ENCHANTMENTS.create("smelter", SmelterEnchantment::create);
        TELEKINESIS = ENCHANTMENTS.create("telekinesis", TelekinesisEnchantment::create);
        BREAKING = ENCHANTMENTS.create("breaking_curse", BreakingCurse::create);
        CORROSION = ENCHANTMENTS.create("corrosion_curse", CorrosionCurse::create);
        FATIGUE = ENCHANTMENTS.create("fatigue_curse", FatigueCurse::create);
        INCOMPATIBILITY = ENCHANTMENTS.create("incompatibility_curse", IncompatibilityCurse::create);
        SLIPPERY = ENCHANTMENTS.create("slippery_curse", SlipperyCurse::create);
        IS_BOW_OR_CROSSBOW = itemStack -> ItemHelper.isRangedWeapon((Item)itemStack.m_41720_());
        IS_GOLDEN = itemStack -> ItemHelper.isGoldenToolOrArmor((Item)itemStack.m_41720_());
        IS_HORSE_ARMOR = itemStack -> itemStack.m_41720_() instanceof HorseArmorItem;
        IS_HOE = itemStack -> itemStack.m_41720_() instanceof HoeItem;
        IS_MELEE_MINECRAFT = itemStack -> itemStack.m_41720_() instanceof SwordItem || itemStack.m_41720_() instanceof AxeItem;
        IS_MELEE = itemStack -> ItemHelper.isMeleeWeapon((Item)itemStack.m_41720_());
        IS_SHIELD = itemStack -> ItemHelper.isShield((Item)itemStack.m_41720_());
        IS_TOOL = itemStack -> ItemHelper.isAnyTool((Item)itemStack.m_41720_());
        DODGE_PARTICLE = PARTICLES.create("dodge", () -> new SimpleParticleType(true){});
        SMELTER_PARTICLE = PARTICLES.create("smelter", () -> new SimpleParticleType(true){});
        TELEKINESIS_PARTICLE = PARTICLES.create("telekinesis", TelekinesisParticleType::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        static {
            HELPER.create(Custom.Particles.class, particles -> {
                particles.register((ParticleType)DODGE_PARTICLE.get(), DodgeParticle.Factory::new);
                particles.register((ParticleType)SMELTER_PARTICLE.get(), SmelterParticle.Factory::new);
                particles.register((ParticleType)TELEKINESIS_PARTICLE.get(), TelekinesisParticle.Factory::new);
            });
        }
    }
}

