/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class DeathWishEnchantment
extends Handler {
    Range<Float> damage = Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(2.0f));
    Range<Float> vulnerability = Range.of((Number)Float.valueOf(0.7f), (Number)Float.valueOf(1.2f));

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_MELEE).slots((List)EquipmentSlots.MAINHAND).minLevelCost(level -> 12).maxLevelCost(level -> 50);
    }

    public DeathWishEnchantment() {
        super(MajruszsEnchantments.DEATH_WISH, DeathWishEnchantment.class, false);
        OnEntityPreDamaged.listen(this::increaseDamageDealt).addCondition(data -> data.attacker != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.attacker));
        OnEntityPreDamaged.listen(this::increaseDamageReceived).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.target));
        this.config.define("damage_multiplier_range", Reader.range((IReader)Reader.number()), s -> this.damage, (s, v) -> {
            this.damage = Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp(v);
        });
        this.config.define("vulnerability_multiplier_range", Reader.range((IReader)Reader.number()), s -> this.vulnerability, (s, v) -> {
            this.vulnerability = Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp(v);
        });
    }

    private void increaseDamageDealt(OnEntityPreDamaged data) {
        float multiplier = this.damage.lerp((float)EntityHelper.getMissingHealthRatio((LivingEntity)data.attacker));
        data.damage *= multiplier;
        if (multiplier > 1.0f) {
            data.spawnMagicParticles = true;
        }
    }

    private void increaseDamageReceived(OnEntityPreDamaged data) {
        data.damage *= this.vulnerability.lerp((float)EntityHelper.getHealthRatio((LivingEntity)data.target));
    }
}

