/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

@AutoInstance
public class DodgeEnchantment
extends Handler {
    float chance = 0.125f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.ARMOR_LEGS).slots((List)EquipmentSlots.LEGS).maxLevel(2).minLevelCost(level -> level * 14).maxLevelCost(level -> level * 14 + 20);
    }

    public DodgeEnchantment() {
        super(MajruszsEnchantments.DODGE, DodgeEnchantment.class, false);
        OnEntityPreDamaged.listen(this::dodge).addCondition(Condition.isLogicalServer()).addCondition(OnEntityPreDamaged::willTakeFullDamage).addCondition(data -> data.attacker != null).addCondition(data -> Random.check((float)((float)EnchantmentHelper.getLevel((Supplier)this.enchantment, (LivingEntity)data.target) * this.chance)));
        this.config.define("dodge_chance_per_level", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
            this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void dodge(OnEntityPreDamaged data) {
        int invisibleDuration = TimeHelper.toTicks((double)1.0);
        data.cancelDamage();
        this.spawnEffects(data, invisibleDuration);
        MajruszLibrary.ENTITY_INVISIBLE.sendToClients((Object)new EntityHelper.EntityInvisible((Entity)data.target, invisibleDuration));
    }

    private void spawnEffects(OnEntityPreDamaged data, int invisibleDuration) {
        TimeHelper.slider((int)invisibleDuration, slider -> {
            boolean isFirstOrLastTick = slider.getTicksLeft() == slider.getTicksTotal() || slider.getTicksLeft() == 0;
            float width = data.target.m_20205_();
            float height = data.target.m_20206_();
            int count = 1;
            if (isFirstOrLastTick) {
                count = 20;
                SoundEmitter.of((SoundEvent)SoundEvents.f_11937_).position(data.target.m_20182_()).volume(SoundEmitter.randomized((float)0.25f)).pitch(SoundEmitter.randomized((float)0.4f)).emit((Level)data.getServerLevel());
            }
            ParticleEmitter.of(MajruszsEnchantments.DODGE_PARTICLE).sizeBased((Entity)data.target).count(count).offset(() -> AnyPos.from((Number)Float.valueOf(width), (Number)Float.valueOf(height), (Number)Float.valueOf(width)).mul((Number)Float.valueOf(1.0f), (Number)Float.valueOf(0.25f), (Number)Float.valueOf(1.0f)).vec3()).speed(0.025f).emit((Level)data.getServerLevel());
        });
    }
}

