/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.level.LevelHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class HorseFrostWalkerEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment(){

            public boolean m_6591_() {
                return true;
            }
        }.rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_HORSE_ARMOR).slots((List)EquipmentSlots.ARMOR).maxLevel(2).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 15);
    }

    public HorseFrostWalkerEnchantment() {
        super(MajruszsEnchantments.HORSE_FROST_WALKER, HorseFrostWalkerEnchantment.class, false);
        OnEntityTicked.listen(this::freezeNearbyWater).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.1f)).addCondition(data -> data.entity instanceof Animal).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.entity));
        OnEntityPreDamaged.listen(OnEntityPreDamaged::cancelDamage).addCondition(Condition.isLogicalServer()).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.target)).addCondition(Condition.predicate(data -> data.source.m_276093_(DamageTypes.f_268434_))).addCondition(Condition.predicate(data -> data.target instanceof Animal));
    }

    private void freezeNearbyWater(OnEntityTicked data) {
        LevelHelper.freezeWater((Entity)data.entity, (double)(EnchantmentHelper.getLevelSum((Supplier)this.enchantment, (LivingEntity)data.entity) + 2), (int)60, (int)120, (boolean)false);
    }
}

