/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class HorseSwiftnessEnchantment
extends Handler {
    final AttributeHandler attribute = new AttributeHandler("%s_speed".formatted(this.enchantment.getId()), () -> Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE);
    float multiplier = 0.125f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_HORSE_ARMOR).slots((List)EquipmentSlots.ARMOR).maxLevel(4).minLevelCost(level -> level * 6).maxLevelCost(level -> level * 6 + 15);
    }

    public HorseSwiftnessEnchantment() {
        super(MajruszsEnchantments.HORSE_SWIFTNESS, HorseSwiftnessEnchantment.class, false);
        OnItemEquipped.listen(this::updateSpeed).addCondition(Condition.isLogicalServer()).addCondition(data -> data.entity instanceof Animal);
        this.config.define("speed_multiplier_per_level", Reader.number(), s -> Float.valueOf(this.multiplier), (s, v) -> {
            this.multiplier = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void updateSpeed(OnItemEquipped data) {
        this.attribute.setValue((double)(this.multiplier * (float)EnchantmentHelper.getLevelSum((Supplier)this.enchantment, (LivingEntity)data.entity))).apply(data.entity);
    }
}

