/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.entity.EntityNoiseListener;
import com.majruszlibrary.events.OnEntityNoiseCheck;
import com.majruszlibrary.events.OnEntityNoiseReceived;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.OnPlayerTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@AutoInstance
public class SixthSenseEnchantment
extends Handler {
    List<ResourceLocation> chestIds = List.of(BuiltInLootTables.f_230876_, BuiltInLootTables.f_230877_);
    ResourceLocation lootId = MajruszsEnchantments.HELPER.getLocation("chests/ancient_city_sixth_sense");
    float glowDuration = 2.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment(){

            public boolean m_6591_() {
                return true;
            }

            public boolean m_6594_() {
                return false;
            }

            public boolean canEnchantUsingEnchantingTable(ItemStack itemStack) {
                return false;
            }
        }.rarity(Enchantment.Rarity.VERY_RARE).category(EnchantmentCategory.ARMOR_HEAD).slots((List)EquipmentSlots.HEAD).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public SixthSenseEnchantment() {
        super(MajruszsEnchantments.SIXTH_SENSE, SixthSenseEnchantment.class, false);
        EntityNoiseListener.add(ServerPlayer.class);
        OnEntityNoiseCheck.listen(OnEntityNoiseCheck::makeAudible).addCondition(data -> data.listener instanceof ServerPlayer).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)((ServerPlayer)data.listener))).addCondition(Condition.isShiftKeyDown(data -> (ServerPlayer)data.listener)).addCondition(Condition.isOnGround(data -> data.listener));
        OnEntityNoiseReceived.listen(this::highlight).addCondition(data -> data.listener instanceof ServerPlayer).addCondition(data -> data.emitter != data.listener).addCondition(data -> data.emitter != null);
        OnPlayerTicked.listen(this::playSound).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)1.25f)).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.player)).addCondition(Condition.isShiftKeyDown(data -> data.player)).addCondition(Condition.isOnGround(data -> data.player));
        OnLootGenerated.listen(this::addToChest).addCondition(Condition.isLogicalServer()).addCondition(data -> this.isEnabled).addCondition(data -> data.origin != null).addCondition(data -> this.chestIds.contains(data.lootId));
        this.config.define("glow_duration", Reader.number(), s -> Float.valueOf(this.glowDuration), (s, v) -> {
            this.glowDuration = ((Float)Range.of((Number)Float.valueOf(0.5f), (Number)Float.valueOf(30.0f)).clamp((Number)v)).floatValue();
        }).define("chest_ids", Reader.list((IReader)Reader.location()), s -> this.chestIds, (s, v) -> {
            this.chestIds = v;
        }).define("loot_id", Reader.location(), s -> this.lootId, (s, v) -> {
            this.lootId = v;
        });
    }

    private void highlight(OnEntityNoiseReceived data) {
        MajruszLibrary.ENTITY_GLOW.sendToClient((ServerPlayer)data.listener, (Object)new EntityHelper.EntityGlow(data.emitter, TimeHelper.toTicks((double)this.glowDuration)));
    }

    private void playSound(OnPlayerTicked data) {
        SoundEmitter.of((SoundEvent)SoundEvents.f_215762_).volume(SoundEmitter.randomized((float)0.3f)).position(data.player.m_20182_()).emit((Level)data.getServerLevel());
    }

    private void addToChest(OnLootGenerated data) {
        LootParams params = new LootParams.Builder(data.getServerLevel()).m_287286_(LootContextParams.f_81460_, (Object)data.origin).m_287235_(LootContextParamSets.f_81411_);
        data.generatedLoot.addAll((ObjectList)LootHelper.getLootTable((ResourceLocation)this.lootId).m_287195_(params));
    }
}

