/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.UntouchingEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class SmelterEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.UNCOMMON).category(EnchantmentCategory.DIGGER).slots((List)EquipmentSlots.MAINHAND).minLevelCost(level -> 15).maxLevelCost(level -> 45).compatibility(enchantment -> !(enchantment instanceof UntouchingEnchantment));
    }

    public SmelterEnchantment() {
        super(MajruszsEnchantments.SMELTER, SmelterEnchantment.class, false);
        OnLootGenerated.listen(this::smelt).priority(Priority.LOW).addCondition(data -> data.blockState != null).addCondition(data -> data.origin != null).addCondition(data -> data.tool != null).addCondition(data -> {
            Player player;
            Entity patt1737$temp = data.entity;
            return patt1737$temp instanceof Player && !(player = (Player)patt1737$temp).m_6047_();
        }).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)data.tool));
    }

    private void smelt(OnLootGenerated data) {
        float experience = 0.0f;
        for (int idx = 0; idx < data.generatedLoot.size(); ++idx) {
            Optional result = ItemHelper.tryToSmelt((Level)data.getLevel(), (ItemStack)((ItemStack)data.generatedLoot.get(idx)));
            if (!result.isPresent()) continue;
            experience += ((ItemHelper.SmeltResult)result.get()).experience();
            data.generatedLoot.set(idx, (Object)((ItemHelper.SmeltResult)result.get()).itemStack());
        }
        int totalExperience = Random.round((double)experience);
        if (totalExperience > 0) {
            EntityHelper.spawnExperience((Level)data.getLevel(), (Vec3)data.origin, (int)totalExperience);
        }
        if (experience > 0.0f) {
            ParticleEmitter.of(MajruszsEnchantments.SMELTER_PARTICLE).count(10).offset(ParticleEmitter.offset((float)0.2f)).speed(0.01f).position(AnyPos.from((Vec3)data.origin).center().vec3()).emit((Level)data.getServerLevel());
        }
    }
}

