/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.livingtool;

import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public enum LivingToolState {
    BROKEN,
    DORMANT,
    AWAKENED;

    public static final String STATE_TAG_KEY = "LivingToolState";

    public static LivingToolState deserialize(CompoundTag tag) {
        return LivingToolState.deserialize(tag.m_128445_(STATE_TAG_KEY));
    }

    public static LivingToolState deserialize(byte stateId) {
        if (stateId >= LivingToolState.values().length) {
            return BROKEN;
        }
        if (stateId < 0) {
            return BROKEN;
        }
        return LivingToolState.values()[stateId];
    }

    public static String getTooltipTranslationKey() {
        return "tooltip.biomancy.living_tool_state_is";
    }

    public MutableComponent getTooltip() {
        return ComponentUtil.translatable(LivingToolState.getTooltipTranslationKey(), ComponentUtil.translatable(this.getTranslationKey()));
    }

    public String getTranslationKey() {
        return "state.biomancy.living_tool." + this.name().toLowerCase(Locale.ENGLISH);
    }

    public MutableComponent getDisplayName() {
        return ComponentUtil.translatable(this.getTranslationKey());
    }

    public void serialize(CompoundTag tag) {
        tag.m_128344_(STATE_TAG_KEY, (byte)this.ordinal());
    }
}

