/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.nutrients.fluid;

import com.github.elenterius.biomancy.api.nutrients.fluid.FluidToFuelConversion;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class FluidNutrients {
    private static final Map<ResourceLocation, FluidToFuelConversion> FLUIDS = new HashMap<ResourceLocation, FluidToFuelConversion>();

    private FluidNutrients() {
    }

    @Nullable
    private static ResourceLocation getRegistryKey(Fluid fluid) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            fluid = flowingFluid.m_5613_();
        }
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static void register(Fluid fluid, FluidToFuelConversion func) {
        ResourceLocation key = FluidNutrients.getRegistryKey(fluid);
        if (key == null) {
            throw new IllegalArgumentException("Couldn't find a valid registry key for fluid " + fluid);
        }
        FLUIDS.put(key, func);
    }

    public static void register(RegistryObject<? extends Fluid> fluidHolder, FluidToFuelConversion func) {
        ResourceLocation key = fluidHolder.getId();
        FLUIDS.put(key, func);
    }

    public static void register(ResourceLocation fluidRegistryKey, FluidToFuelConversion func) {
        FLUIDS.put(fluidRegistryKey, func);
    }

    public static boolean isValid(FluidStack fluidStack) {
        ResourceLocation key = FluidNutrients.getRegistryKey(fluidStack.getFluid());
        return key != null && FLUIDS.containsKey(key);
    }

    @Nullable
    public static FluidToFuelConversion getConversion(FluidStack fluidStack) {
        ResourceLocation key = FluidNutrients.getRegistryKey(fluidStack.getFluid());
        if (key == null) {
            return null;
        }
        return FLUIDS.get(key);
    }
}

