/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.tribute.fluid;

import com.github.elenterius.biomancy.api.tribute.SacrificeHandler;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidToTributeConversion;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidTribute;
import com.github.elenterius.biomancy.api.tribute.fluid.FluidTributes;
import com.github.elenterius.biomancy.inventory.Notify;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTributeConsumerHandler
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    public static final String MILLI_TRIBUTE_BUFFER_KEY = "MilliTributeBuffer";
    private final SacrificeHandler sacrificeHandler;
    private final Notify onChange;
    private final long[] milliTributeBuffer = new long[6];

    public FluidTributeConsumerHandler(SacrificeHandler sacrificeHandler, Notify onChange) {
        this.sacrificeHandler = sacrificeHandler;
        this.onChange = onChange;
    }

    public boolean isFluidValid(int tank, FluidStack resource) {
        return !this.sacrificeHandler.isFull() && FluidTributes.isValid(resource);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (this.sacrificeHandler.isFull()) {
            return 0;
        }
        FluidToTributeConversion conversion = FluidTributes.getConversion(resource);
        if (conversion == null) {
            return 0;
        }
        FluidTribute fluidTribute = conversion.getTributePerUnit(resource);
        if (fluidTribute.isEmpty()) {
            return 0;
        }
        if (fluidTribute.biomass() > 0 && this.sacrificeHandler.isBiomassFull()) {
            return 0;
        }
        long amountToConsume = resource.getAmount();
        int biomassYield = (int)((this.milliTributeBuffer[0] + (long)fluidTribute.biomass() * amountToConsume) / 1000L);
        int biomassToFill = Math.min(this.sacrificeHandler.getMaxBiomass() - this.sacrificeHandler.getBiomassAmount(), biomassYield);
        if (biomassToFill > 0) {
            long remainder;
            long biomassMissing = (long)biomassToFill * 1000L - this.milliTributeBuffer[0];
            amountToConsume = Mth.m_14167_((float)((float)biomassMissing / (float)fluidTribute.biomass()));
            if (action.simulate()) {
                return (int)amountToConsume;
            }
            this.sacrificeHandler.addBiomass(biomassToFill);
            this.milliTributeBuffer[0] = remainder = (long)fluidTribute.biomass() * amountToConsume - biomassMissing;
        }
        if (action.simulate()) {
            return (int)amountToConsume;
        }
        this.milliTributeBuffer[1] = this.milliTributeBuffer[1] + (long)fluidTribute.lifeEnergy() * amountToConsume;
        int yield = (int)(this.milliTributeBuffer[1] / 1000L);
        this.sacrificeHandler.addLifeEnergy(yield);
        this.milliTributeBuffer[1] = this.milliTributeBuffer[1] - (long)yield * 1000L;
        this.milliTributeBuffer[2] = this.milliTributeBuffer[2] + (long)fluidTribute.successModifier() * amountToConsume;
        yield = (int)(this.milliTributeBuffer[2] / 1000L);
        this.sacrificeHandler.addSuccess(yield);
        this.milliTributeBuffer[2] = this.milliTributeBuffer[2] - (long)yield * 1000L;
        this.milliTributeBuffer[3] = this.milliTributeBuffer[3] + (long)fluidTribute.hostileModifier() * amountToConsume;
        yield = (int)(this.milliTributeBuffer[3] / 1000L);
        this.sacrificeHandler.addHostile(yield);
        this.milliTributeBuffer[3] = this.milliTributeBuffer[3] - (long)yield * 1000L;
        this.milliTributeBuffer[4] = this.milliTributeBuffer[4] + (long)fluidTribute.diseaseModifier() * amountToConsume;
        yield = (int)(this.milliTributeBuffer[4] / 1000L);
        this.sacrificeHandler.addDisease(yield);
        this.milliTributeBuffer[4] = this.milliTributeBuffer[4] - (long)yield * 1000L;
        this.milliTributeBuffer[5] = this.milliTributeBuffer[5] + (long)fluidTribute.anomalyModifier() * amountToConsume;
        yield = (int)(this.milliTributeBuffer[5] / 1000L);
        this.sacrificeHandler.addAnomaly(yield);
        this.milliTributeBuffer[5] = this.milliTributeBuffer[5] - (long)yield * 1000L;
        if (this.sacrificeHandler.isDirty()) {
            this.onChange.invoke();
            this.sacrificeHandler.setDirty(false);
        }
        return (int)amountToConsume;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 250;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128388_(MILLI_TRIBUTE_BUFFER_KEY, this.milliTributeBuffer);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        long[] buffer = tag.m_128467_(MILLI_TRIBUTE_BUFFER_KEY);
        System.arraycopy(buffer, 0, this.milliTributeBuffer, 0, this.milliTributeBuffer.length);
    }
}

