/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block;

import com.github.elenterius.biomancy.block.property.Orientation;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IrisDoorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<Orientation> ORIENTATION = ModBlockProperties.ORIENTATION;
    protected static final int THICKNESS = 2;
    protected static final int CLOSED_SHAPE_INDEX = 0;
    protected static final int OPEN_SHAPE_INDEX = 1;
    protected static final VoxelShape[] Y_POS_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape[] Y_NONE_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 7.0, 0.0, 16.0, 9.0, 16.0);
    protected static final VoxelShape[] Y_NEG_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] x_NEG_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 2.0, 16.0, 16.0);
    protected static final VoxelShape[] x_NONE_AABB = IrisDoorBlock.createClosedAndOpenShape(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    protected static final VoxelShape[] X_POS_AABB = IrisDoorBlock.createClosedAndOpenShape(14.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] Z_NEG_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    protected static final VoxelShape[] Z_NONE_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 0.0, 7.0, 16.0, 16.0, 9.0);
    protected static final VoxelShape[] Z_POS_AABB = IrisDoorBlock.createClosedAndOpenShape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);

    public IrisDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)((Object)Orientation.Y_MIDDLE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape[] createClosedAndOpenShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        VoxelShape closedShape = Block.m_49796_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
        boolean caseX = x0 == 0.0 && x1 == 16.0;
        boolean caseY = y0 == 0.0 && y1 == 16.0;
        boolean caseZ = z0 == 0.0 && z1 == 16.0;
        double offset = 2.0;
        double xA = caseX ? x0 + offset : x0;
        double yA = caseY ? y0 + offset : y0;
        double zA = caseZ ? z0 + offset : z0;
        double xB = caseX ? x1 - offset : x1;
        double yB = caseY ? y1 - offset : y1;
        double zB = caseZ ? z1 - offset : z1;
        VoxelShape openShape = Shapes.m_83113_((VoxelShape)closedShape, (VoxelShape)Block.m_49796_((double)xA, (double)yA, (double)zA, (double)xB, (double)yB, (double)zB), (BooleanOp)BooleanOp.f_82687_);
        return new VoxelShape[]{closedShape, openShape};
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ORIENTATION, OPEN, POWERED, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        if (!context.m_7058_()) {
            Orientation orientation = Orientation.getOrientationFrom(context);
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation));
        }
        if (context.m_43725_().m_276867_(context.m_8083_())) {
            state = (BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 2);
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        this.triggerEvents(player, level, pos, this.isOpen(state));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        boolean hasSignal = level.m_276867_(pos);
        if (hasSignal != this.isPowered(state)) {
            if (this.isOpen(state) != hasSignal) {
                state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasSignal));
                this.triggerEvents(null, level, pos, hasSignal);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(hasSignal)), 2);
            if (this.isWaterlogged(state)) {
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
        }
    }

    protected void triggerEvents(@Nullable Player player, Level level, BlockPos pos, boolean open) {
        this.playSound(player, level, pos, open ? (SoundEvent)ModSoundEvents.FLESH_DOOR_OPEN.get() : (SoundEvent)ModSoundEvents.FLESH_DOOR_CLOSE.get());
        level.m_142346_((Entity)player, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    private void playSound(@Nullable Player player, Level level, BlockPos pos, SoundEvent sound) {
        level.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public FluidState m_5888_(BlockState state) {
        return this.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public boolean isWaterlogged(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        if (this.isOpen(state) && ((Orientation)((Object)state.m_61143_(IrisDoorBlock.ORIENTATION))).axis.m_122478_()) {
            BlockState stateBelow = level.m_8055_(pos.m_7495_());
            if (stateBelow.m_60734_() instanceof IrisDoorBlock) {
                return ((Orientation)((Object)stateBelow.m_61143_(IrisDoorBlock.ORIENTATION))).axis == ((Orientation)((Object)state.m_61143_(IrisDoorBlock.ORIENTATION))).axis;
            }
            return stateBelow.m_60734_() instanceof LadderBlock || stateBelow.m_204336_(BlockTags.f_13082_);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx = this.isOpen(state) ? 1 : 0;
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> x_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> x_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            case Orientation.Y_POSITIVE -> Y_POS_AABB[idx];
            case Orientation.Y_NEGATIVE -> Y_NEG_AABB[idx];
            case Orientation.Y_MIDDLE -> Y_NONE_AABB[idx];
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.isOpen(state) ? Shapes.m_83040_() : state.m_60808_(level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (this.isWaterlogged(state)) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotationDirection) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> this.isOpen(state);
            case PathComputationType.WATER -> this.isWaterlogged(state);
        };
    }
}

