/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block;

import com.github.elenterius.biomancy.block.property.Orientation;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PaneBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Orientation> ORIENTATION = ModBlockProperties.ORIENTATION;
    protected static final int THICKNESS = 4;
    protected static final VoxelShape Y_POS_AABB = PaneBlock.createShape(0.0, 0.0, 0.0, 16.0, 4.0, 16.0);
    protected static final VoxelShape Y_NONE_AABB = PaneBlock.createShape(0.0, 6.0, 0.0, 16.0, 10.0, 16.0);
    protected static final VoxelShape Y_NEG_AABB = PaneBlock.createShape(0.0, 12.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape x_NEG_AABB = PaneBlock.createShape(0.0, 0.0, 0.0, 4.0, 16.0, 16.0);
    protected static final VoxelShape x_NONE_AABB = PaneBlock.createShape(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);
    protected static final VoxelShape X_POS_AABB = PaneBlock.createShape(12.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape Z_NEG_AABB = PaneBlock.createShape(0.0, 0.0, 0.0, 16.0, 16.0, 4.0);
    protected static final VoxelShape Z_NONE_AABB = PaneBlock.createShape(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape Z_POS_AABB = PaneBlock.createShape(0.0, 0.0, 12.0, 16.0, 16.0, 16.0);

    public PaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(ORIENTATION, (Comparable)((Object)Orientation.Y_MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape createShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        return Block.m_49796_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
    }

    public static Orientation getOrientation(BlockState state) {
        return (Orientation)((Object)state.m_61143_(ORIENTATION));
    }

    public static boolean canWallConnectToPane(BlockState paneState, Direction wallDirection) {
        Orientation orientation = PaneBlock.getOrientation(paneState);
        return orientation.isMiddle() && orientation.axis == wallDirection.m_122427_().m_122434_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ORIENTATION, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        if (!context.m_7058_()) {
            Orientation orientation = Orientation.getOrientationFrom(context);
            state = (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (this.isWaterlogged(state)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    public FluidState m_5888_(BlockState state) {
        return this.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean isWaterlogged(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Orientation)((Object)state.m_61143_(ORIENTATION))) {
            default -> throw new IncompatibleClassChangeError();
            case Orientation.X_POSITIVE -> X_POS_AABB;
            case Orientation.X_MIDDLE -> x_NONE_AABB;
            case Orientation.X_NEGATIVE -> x_NEG_AABB;
            case Orientation.Z_POSITIVE -> Z_POS_AABB;
            case Orientation.Z_MIDDLE -> Z_NONE_AABB;
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB;
            case Orientation.Y_POSITIVE -> Y_POS_AABB;
            case Orientation.Y_NEGATIVE -> Y_NEG_AABB;
            case Orientation.Y_MIDDLE -> Y_NONE_AABB;
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (this.isWaterlogged(state)) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotationDirection) {
        Orientation orientation = PaneBlock.getOrientation(state);
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Orientation orientation = PaneBlock.getOrientation(state);
        return (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

