/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.base;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.FuelHandler;
import com.github.elenterius.biomancy.block.base.MachineBlock;
import com.github.elenterius.biomancy.crafting.recipe.ProcessingRecipe;
import com.github.elenterius.biomancy.crafting.state.CraftingState;
import com.github.elenterius.biomancy.crafting.state.RecipeCraftingStateData;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.util.PlayerInteractionPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlockEntity<R extends ProcessingRecipe, S extends RecipeCraftingStateData<R>>
extends BlockEntity
implements Nameable,
PlayerInteractionPredicate {
    protected final int tickOffset;
    protected int ticks;

    protected MachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.ticks = this.tickOffset = BiomancyMod.GLOBAL_RANDOM.nextInt(20);
    }

    public static <R extends ProcessingRecipe, S extends RecipeCraftingStateData<R>> void serverTick(Level level, BlockPos pos, BlockState state, MachineBlockEntity<R, S> entity) {
        entity.serverTick((ServerLevel)level);
    }

    @Override
    public boolean canPlayerInteract(Player player) {
        if (this.m_58901_()) {
            return false;
        }
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20238_(Vec3.m_82512_((Vec3i)this.f_58858_)) < 64.0;
    }

    protected void onInventoryChanged() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public int getTicks() {
        return this.ticks - this.tickOffset;
    }

    protected abstract S getStateData();

    protected abstract InventoryHandler getInputInventory();

    protected abstract FuelHandler getFuelHandler();

    public int getFuelCost(R recipeToCraft) {
        return this.getFuelHandler().getFuelCost(recipeToCraft.getCraftingCostNutrients((Container)this.getInputInventory().getRecipeWrapper()));
    }

    public abstract ItemStack getStackInFuelSlot();

    public abstract void setStackInFuelSlot(ItemStack var1);

    protected abstract boolean doesRecipeResultFitIntoOutputInv(R var1, ItemStack var2);

    protected abstract boolean craftRecipe(R var1, Level var2);

    @Nullable
    protected abstract R resolveRecipeFromInput(Level var1);

    protected abstract boolean doesRecipeMatchInput(R var1, Level var2);

    public abstract void dropAllInvContents(Level var1, BlockPos var2);

    public boolean hasEnoughFuel(R recipeToCraft) {
        return this.getFuelHandler().getFuelAmount() >= this.getFuelCost(recipeToCraft);
    }

    public void refuel() {
        if (this.getFuelHandler().getFuelAmount() < this.getFuelHandler().getMaxFuelAmount()) {
            ItemStack remainder;
            ItemStack stack = this.getStackInFuelSlot();
            if (this.getFuelHandler().isValidFuel(stack) && (remainder = this.getFuelHandler().addFuel(stack)).m_41613_() != stack.m_41613_()) {
                this.setStackInFuelSlot(remainder);
                this.m_6596_();
            }
        }
    }

    protected void serverTick(ServerLevel level) {
        ++this.ticks;
        if (this.ticks % 8 == 0) {
            this.refuel();
        }
        S state = this.getStateData();
        ProcessingRecipe craftingGoal = ((RecipeCraftingStateData)state).getCraftingGoalRecipe((Level)level).filter(r -> this.doesRecipeMatchInput(r, (Level)level)).orElseGet(() -> this.resolveRecipeFromInput((Level)level));
        boolean emitRedstoneSignal = false;
        if (craftingGoal == null) {
            ((RecipeCraftingStateData)state).cancelCrafting();
        } else {
            ItemStack itemToCraft = this.getItemToCraft(level, craftingGoal);
            if (itemToCraft.m_41619_()) {
                ((RecipeCraftingStateData)state).cancelCrafting();
            } else if (this.doesRecipeResultFitIntoOutputInv(craftingGoal, itemToCraft)) {
                ProcessingRecipe prevCraftingGoal;
                if (((RecipeCraftingStateData)state).getCraftingState() == CraftingState.NONE) {
                    ((RecipeCraftingStateData)state).setCraftingGoalRecipe((ProcessingRecipe)craftingGoal, (Container)this.getInputInventory().getRecipeWrapper());
                    if (this.hasEnoughFuel(craftingGoal)) {
                        ((RecipeCraftingStateData)state).setCraftingState(CraftingState.IN_PROGRESS);
                    }
                } else if (!(((RecipeCraftingStateData)state).isCraftingCanceled() || (prevCraftingGoal = (ProcessingRecipe)((RecipeCraftingStateData)state).getCraftingGoalRecipe((Level)level).orElse(null)) != null && craftingGoal.isRecipeEqual(prevCraftingGoal))) {
                    ((RecipeCraftingStateData)state).cancelCrafting();
                }
            } else if (((RecipeCraftingStateData)state).getCraftingState() != CraftingState.COMPLETED) {
                ((RecipeCraftingStateData)state).cancelCrafting();
            }
            if (((RecipeCraftingStateData)state).getCraftingState() == CraftingState.IN_PROGRESS) {
                ((RecipeCraftingStateData)state).timeElapsed = this.hasEnoughFuel(craftingGoal) ? ++((RecipeCraftingStateData)state).timeElapsed : (((RecipeCraftingStateData)state).timeElapsed -= 2);
                if (((RecipeCraftingStateData)state).timeElapsed < 0) {
                    ((RecipeCraftingStateData)state).timeElapsed = 0;
                }
            }
            if ((((RecipeCraftingStateData)state).getCraftingState() == CraftingState.IN_PROGRESS || ((RecipeCraftingStateData)state).getCraftingState() == CraftingState.COMPLETED) && ((RecipeCraftingStateData)state).timeElapsed >= ((RecipeCraftingStateData)state).timeForCompletion) {
                ((RecipeCraftingStateData)state).setCraftingState(CraftingState.COMPLETED);
                if (this.craftRecipe(craftingGoal, (Level)level)) {
                    this.getFuelHandler().addFuelAmount(-this.getFuelCost(craftingGoal));
                    emitRedstoneSignal = true;
                    ((RecipeCraftingStateData)state).setCraftingState(CraftingState.NONE);
                }
            }
        }
        if (((RecipeCraftingStateData)state).isCraftingCanceled()) {
            ((RecipeCraftingStateData)state).setCraftingState(CraftingState.NONE);
        }
        this.updateBlockState((Level)level, state, emitRedstoneSignal);
    }

    private ItemStack getItemToCraft(ServerLevel level, R craftingGoal) {
        if (craftingGoal.m_5598_()) {
            return craftingGoal.m_5874_((Container)this.getInputInventory().getRecipeWrapper(), level.m_9598_());
        }
        return craftingGoal.m_8043_(level.m_9598_());
    }

    protected BooleanProperty getIsCraftingBlockStateProperty() {
        return ModBlockProperties.IS_CRAFTING;
    }

    protected void updateBlockState(Level world, S tileState, boolean redstoneSignal) {
        Block block;
        BlockState oldBlockState = world.m_8055_(this.f_58858_);
        BlockState newBlockState = (BlockState)oldBlockState.m_61124_((Property)this.getIsCraftingBlockStateProperty(), (Comparable)Boolean.valueOf(((RecipeCraftingStateData)tileState).getCraftingState() == CraftingState.IN_PROGRESS));
        if (!newBlockState.equals(oldBlockState)) {
            if (redstoneSignal) {
                Block block2 = newBlockState.m_60734_();
                if (block2 instanceof MachineBlock) {
                    MachineBlock machine = (MachineBlock)block2;
                    machine.powerBlock(world, this.f_58858_, newBlockState);
                }
            } else {
                world.m_7731_(this.f_58858_, newBlockState, 2);
            }
            this.m_6596_();
        } else if (redstoneSignal && (block = newBlockState.m_60734_()) instanceof MachineBlock) {
            MachineBlock machine = (MachineBlock)block;
            machine.powerBlock(world, this.f_58858_, oldBlockState);
        }
    }
}

