/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.bioforge;

import com.github.elenterius.biomancy.block.bioforge.BioForgeBlockEntity;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BioForgeBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = BioForgeBlock.createShape();

    private static VoxelShape createShape() {
        VoxelShape base = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
        VoxelShape outer = Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        return Shapes.m_83113_((VoxelShape)base, (VoxelShape)outer, (BooleanOp)BooleanOp.f_82695_);
    }

    public BioForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.BIO_FORGE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BioForgeBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BIO_FORGE.get()), (BlockEntityTicker)(level.f_46443_ ? BioForgeBlockEntity::clientTick : BioForgeBlockEntity::serverTick));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BioForgeBlockEntity) {
            BioForgeBlockEntity bioForge = (BioForgeBlockEntity)blockEntity;
            bioForge.recheckOpen();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BioForgeBlockEntity bioForge;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BioForgeBlockEntity && (bioForge = (BioForgeBlockEntity)blockEntity).canPlayerInteract(player)) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)bioForge, buffer -> buffer.m_130064_(pos));
                SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.UI_BIO_FORGE_OPEN);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BioForgeBlockEntity) {
                BioForgeBlockEntity machine = (BioForgeBlockEntity)blockEntity;
                machine.dropAllInvContents(level, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 0.5f, level.m_269111_().m_268989_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int fuelAmount = BioForgeBlock.getFuelAmount(stack);
        if (fuelAmount > 0) {
            tooltip.add(ComponentUtil.emptyLine());
            DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
            tooltip.add((Component)ComponentUtil.translatable("tooltip.biomancy.nutrients_fuel").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)ComponentUtil.literal("%s/%s u".formatted(df.format(fuelAmount), df.format(1000L))).m_130948_(TextStyles.NUTRIENTS));
        }
    }

    public static int getFuelAmount(ItemStack stack) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        return tag != null && tag.m_128441_("Fuel") ? (int)tag.m_128448_("Fuel") : 0;
    }
}

