/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.bioforge;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.FuelHandler;
import com.github.elenterius.biomancy.api.nutrients.FuelHandlerImpl;
import com.github.elenterius.biomancy.block.bioforge.BioForgeStateData;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandlers;
import com.github.elenterius.biomancy.inventory.ItemHandlerUtil;
import com.github.elenterius.biomancy.menu.BioForgeMenu;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.PlayerInteractionPredicate;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BioForgeBlockEntity
extends BlockEntity
implements MenuProvider,
PlayerInteractionPredicate,
Nameable,
GeoBlockEntity {
    public static final int FUEL_SLOTS = 1;
    public static final int MAX_FUEL = 1000;
    static final int OPENERS_CHANGE_EVENT = 1;
    protected final int tickOffset = BiomancyMod.GLOBAL_RANDOM.nextInt(20);
    private final BioForgeStateData stateData;
    private final FuelHandlerImpl fuelHandler;
    private final InventoryHandler<?> fuelInventory;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int prevOpenCount, int openCount) {
            if (openCount != prevOpenCount) {
                level.m_7696_(BioForgeBlockEntity.this.f_58858_, state.m_60734_(), 1, openCount);
            }
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof BioForgeMenu) {
                BioForgeMenu menu = (BioForgeMenu)abstractContainerMenu;
                return menu.getStateData() == BioForgeBlockEntity.this.stateData;
            }
            return false;
        }
    };
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected int ticks = this.tickOffset;
    private boolean playWorkingAnimation = false;
    private int nearbyTimer = -10;
    private LazyOptional<IFluidHandler> optionalFluidConsumer;

    public BioForgeBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BIO_FORGE.get(), worldPosition, blockState);
        this.fuelInventory = InventoryHandlers.filterFuel(1, this::onInventoryChanged);
        this.fuelHandler = FuelHandlerImpl.createNutrientFuelHandler(1000, () -> ((BioForgeBlockEntity)this).m_6596_());
        this.stateData = new BioForgeStateData(this.fuelHandler);
        this.optionalFluidConsumer = LazyOptional.of(this.fuelHandler::getFluidConsumer);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BioForgeBlockEntity entity) {
        entity.serverTick((ServerLevel)level);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BioForgeBlockEntity entity) {
        entity.clientTick(level);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.playWorkingAnimation = type > 0;
            return true;
        }
        return super.m_7531_(id, type);
    }

    @Override
    public boolean canPlayerInteract(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20238_(Vec3.m_82512_((Vec3i)this.f_58858_)) < 64.0;
    }

    protected void onInventoryChanged() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public void startOpen(Player player) {
        if (this.f_58859_ || player.m_5833_()) {
            return;
        }
        this.openersCounter.m_155452_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
    }

    public void stopOpen(Player player) {
        if (this.f_58859_ || player.m_5833_()) {
            return;
        }
        this.openersCounter.m_155468_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
    }

    public void recheckOpen() {
        if (this.f_58859_) {
            return;
        }
        this.openersCounter.m_155476_(Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return BioForgeMenu.createServerMenu(containerId, playerInventory, this);
    }

    public InventoryHandler<?> getFuelInventory() {
        return this.fuelInventory;
    }

    public BioForgeStateData getStateData() {
        return this.stateData;
    }

    protected void serverTick(ServerLevel level) {
        ++this.ticks;
        if (this.ticks % 8 == 0) {
            this.refuel();
        }
    }

    protected FuelHandler getFuelHandler() {
        return this.fuelHandler;
    }

    public void refuel() {
        if (this.getFuelHandler().getFuelAmount() < this.getFuelHandler().getMaxFuelAmount()) {
            ItemStack remainder;
            ItemStack stack = this.getStackInFuelSlot();
            if (this.getFuelHandler().isValidFuel(stack) && (remainder = this.getFuelHandler().addFuel(stack)).m_41613_() != stack.m_41613_()) {
                this.setStackInFuelSlot(remainder);
                this.m_6596_();
            }
        }
    }

    public int getMaxFuelAmount() {
        return 1000;
    }

    public ItemStack getStackInFuelSlot() {
        return this.fuelInventory.getStackInSlot(0);
    }

    public void setStackInFuelSlot(ItemStack stack) {
        this.fuelInventory.setStackInSlot(0, stack);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Fuel", (Tag)this.fuelHandler.serializeNBT());
        tag.m_128365_("FuelSlots", (Tag)this.fuelInventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuelHandler.deserializeNBT(tag.m_128469_("Fuel"));
        this.fuelInventory.deserializeNBT(tag.m_128469_("FuelSlots"));
    }

    public void dropAllInvContents(Level level, BlockPos pos) {
        ItemHandlerUtil.dropContents(level, pos, this.fuelInventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_) {
            return super.getCapability(cap, side);
        }
        if (cap == ModCapabilities.ITEM_HANDLER && side != null && side.m_122434_().m_122479_()) {
            return this.fuelInventory.getLazyOptional().cast();
        }
        if (cap == ModCapabilities.FLUID_HANDLER) {
            return this.optionalFluidConsumer.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fuelInventory.invalidate();
        this.optionalFluidConsumer.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.fuelInventory.revive();
        this.optionalFluidConsumer = LazyOptional.of(this.fuelHandler::getFluidConsumer);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return TextComponentUtil.getTranslationText("container", "bio_forge");
    }

    protected void clientTick(Level level) {
        if (this.playWorkingAnimation) {
            return;
        }
        BlockPos pos = this.m_58899_();
        Player player = level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4.5, false);
        this.nearbyTimer = Mth.m_14045_((int)(this.nearbyTimer + (player != null ? 1 : -1)), (int)-10, (int)10);
    }

    private <T extends BioForgeBlockEntity> PlayState handleAnimationState(AnimationState<T> state) {
        if (this.playWorkingAnimation) {
            return state.setAndContinue(Animations.WORKING);
        }
        if (this.nearbyTimer > 0) {
            if (state.isCurrentAnimation(Animations.WORKING)) {
                return state.setAndContinue(Animations.UNFOLDED);
            }
            if (!state.isCurrentAnimation(Animations.UNFOLDED) && !state.isCurrentAnimation(Animations.UNFOLDING)) {
                return state.setAndContinue(Animations.UNFOLDING);
            }
            return state.setAndContinue(Animations.UNFOLDED);
        }
        if (!state.isCurrentAnimation(Animations.FOLDED) && !state.isCurrentAnimation(Animations.FOLDING)) {
            return state.setAndContinue(Animations.FOLDING);
        }
        return state.setAndContinue(Animations.FOLDED);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", 10, this::handleAnimationState);
        controller.setAnimation(Animations.FOLDED);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class Animations {
        protected static final String MAIN_CONTROLLER = "main";
        protected static final RawAnimation UNFOLDING = RawAnimation.begin().thenPlay("bio_forge.unfold").thenLoop("bio_forge.idle");
        protected static final RawAnimation UNFOLDED = RawAnimation.begin().thenLoop("bio_forge.idle");
        protected static final RawAnimation FOLDING = RawAnimation.begin().thenPlay("bio_forge.fold").thenLoop("bio_forge.folded_state");
        protected static final RawAnimation FOLDED = RawAnimation.begin().thenLoop("bio_forge.folded_state");
        protected static final RawAnimation WORKING = RawAnimation.begin().thenLoop("bio_forge.working");

        private Animations() {
        }
    }
}

