/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.digester;

import com.github.elenterius.biomancy.block.base.HorizontalFacingMachineBlock;
import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.block.digester.DigesterBlockEntity;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class DigesterBlock
extends HorizontalFacingMachineBlock {
    protected static final VoxelShape SHAPE = DigesterBlock.createShape();

    public DigesterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static VoxelShape createShape() {
        VoxelShape base = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        VoxelShape lid = Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        return Shapes.m_83113_((VoxelShape)base, (VoxelShape)lid, (BooleanOp)BooleanOp.f_82695_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.DIGESTER.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : DigesterBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.DIGESTER.get()), MachineBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DigesterBlockEntity digester;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DigesterBlockEntity && (digester = (DigesterBlockEntity)blockEntity).canPlayerInteract(player)) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)digester, buffer -> buffer.m_130064_(pos));
                SoundUtil.broadcastBlockSound((ServerLevel)level, pos, ModSoundEvents.UI_DIGESTER_OPEN);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(5) != 0) {
            return;
        }
        if (!this.isCrafting(state)) {
            return;
        }
        int particleAmount = random.m_216339_(1, 5);
        int color = 8814134;
        double r = (double)(color >> 16 & 0xFF) / 255.0;
        double g = (double)(color >> 8 & 0xFF) / 255.0;
        double b = (double)(color & 0xFF) / 255.0;
        for (int i = 0; i < particleAmount; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + (double)((random.m_188501_() - random.m_188501_()) * 0.125f), (double)pos.m_123342_() + 0.9, (double)pos.m_123343_() + 0.5 + (double)((random.m_188501_() - random.m_188501_()) * 0.125f), r, g, b);
        }
        if (random.m_188503_(3) != 0) {
            return;
        }
        if (!this.playFoodEatingSound(level, pos, random)) {
            SoundUtil.clientPlayBlockSound(level, pos, ModSoundEvents.DIGESTER_CRAFTING_RANDOM, 0.65f);
        }
    }

    public boolean isCrafting(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)CRAFTING));
    }

    private boolean playFoodEatingSound(Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DigesterBlockEntity) {
            DigesterBlockEntity digester = (DigesterBlockEntity)blockEntity;
            ItemStack stack = digester.getInputSlotStack();
            if (stack.m_41619_()) {
                return false;
            }
            if (stack.m_41780_() == UseAnim.DRINK) {
                SoundUtil.clientPlayBlockSound(level, pos, stack.m_41615_(), 0.5f, random.m_188501_() * 0.1f + 0.9f);
            } else if (stack.m_41780_() == UseAnim.EAT) {
                SoundUtil.clientPlayBlockSound(level, pos, stack.m_41616_(), 0.5f + 0.5f * (float)random.m_188503_(2), (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
            }
            return true;
        }
        return false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        int fuelAmount = DigesterBlock.getFuelAmount(stack);
        if (fuelAmount > 0) {
            tooltip.add(ComponentUtil.emptyLine());
            DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
            tooltip.add((Component)ComponentUtil.translatable("tooltip.biomancy.nutrients_fuel").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)ComponentUtil.literal("%s/%s u".formatted(df.format(fuelAmount), df.format(1000L))).m_130948_(TextStyles.NUTRIENTS));
        }
    }

    public static int getFuelAmount(ItemStack stack) {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        return tag != null && tag.m_128441_("Fuel") ? tag.m_128469_("Fuel").m_128451_("Amount") : 0;
    }
}

