/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.membrane;

import com.github.elenterius.biomancy.block.base.SimpleSyncedBlockEntity;
import com.github.elenterius.biomancy.block.membrane.Membrane;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.item.EssenceItem;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BiometricMembraneBlockEntity
extends SimpleSyncedBlockEntity
implements Membrane {
    public static final String MEMBRANE_KEY = "membrane";
    public static final String ENTITY_TYPE_KEY = "entity_type";
    public static final String ENTITY_UUID_KEY = "entity_uuid";
    public static final String ENTITY_COLORS_KEY = "entity_colors";
    public static final String IS_INVERTED_KEY = "is_inverted";
    public static final int[] DEFAULT_COLORS = new int[]{-1, -1};
    @Nullable
    private EntityType<?> entityType;
    @Nullable
    private UUID entityUUID = null;
    private int[] entityColors = DEFAULT_COLORS;
    private boolean isInverted = false;

    public BiometricMembraneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BIOMETRIC_MEMBRANE.get(), pos, state);
        this.reRenderBlockOnSync = true;
    }

    public void setEntityFilter(LivingEntity entity) {
        this.entityType = entity.m_6095_();
        this.entityUUID = entity.m_20148_();
        this.entityColors = EssenceItem.getEssenceColors(entity, 3);
        this.m_6596_();
        this.syncToClient();
    }

    public void setEntityFilter(EntityType<?> entityType) {
        this.entityType = entityType;
        this.entityColors = EssenceItem.getEssenceColors(entityType);
        this.m_6596_();
        this.syncToClient();
    }

    public boolean setEntityFilter(ItemStack stack, EssenceItem essenceItem) {
        Optional<EntityType<?>> optional = essenceItem.getEntityType(stack);
        if (optional.isEmpty()) {
            return false;
        }
        this.entityType = optional.orElse(null);
        this.entityUUID = essenceItem.getEntityUUID(stack).orElse(null);
        this.entityColors = essenceItem.getColors(stack);
        this.m_6596_();
        this.syncToClient();
        return true;
    }

    public void invertFilters() {
        this.isInverted = !this.isInverted;
        this.m_6596_();
        this.syncToClient();
    }

    @Override
    public boolean shouldIgnoreEntityCollisionAt(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (this.entityUUID != null) {
            boolean isSameEntityUUID = entity.m_20148_().equals(this.entityUUID);
            return this.isInverted != isSameEntityUUID;
        }
        if (this.entityType != null) {
            boolean isSameEntityType = entity.m_6095_() == this.entityType;
            return this.isInverted != isSameEntityType;
        }
        return false;
    }

    @Override
    protected void saveForSyncToClient(CompoundTag compoundTag) {
        this.save(compoundTag);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        this.save(compoundTag);
    }

    protected void save(CompoundTag compoundTag) {
        CompoundTag tag = new CompoundTag();
        if (this.entityType != null) {
            tag.m_128359_(ENTITY_TYPE_KEY, EntityType.m_20613_(this.entityType).toString());
        }
        if (this.entityUUID != null) {
            tag.m_128362_(ENTITY_UUID_KEY, this.entityUUID);
        }
        if (this.entityColors != DEFAULT_COLORS && (this.entityColors[0] != -1 || this.entityColors[1] != -1)) {
            tag.m_128385_(ENTITY_COLORS_KEY, this.entityColors);
        }
        if (this.isInverted) {
            tag.m_128379_(IS_INVERTED_KEY, true);
        }
        compoundTag.m_128365_(MEMBRANE_KEY, (Tag)tag);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        CompoundTag tag = compoundTag.m_128469_(MEMBRANE_KEY);
        this.entityType = EntityType.m_20632_((String)tag.m_128461_(ENTITY_TYPE_KEY)).orElse(null);
        this.entityUUID = tag.m_128403_(ENTITY_UUID_KEY) ? tag.m_128342_(ENTITY_UUID_KEY) : null;
        this.entityColors = tag.m_128425_(ENTITY_COLORS_KEY, 11) ? tag.m_128465_(ENTITY_COLORS_KEY) : DEFAULT_COLORS;
        this.isInverted = tag.m_128471_(IS_INVERTED_KEY);
    }

    public int[] getColors() {
        return this.entityColors;
    }
}

