/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.ownable;

import com.github.elenterius.biomancy.block.base.IBlockEntityDelegator;
import com.github.elenterius.biomancy.block.ownable.OwnableBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.util.ownable.Ownable;
import com.github.elenterius.biomancy.util.ownable.OwnableEntityBlock;
import com.github.elenterius.biomancy.util.permission.Actions;
import com.github.elenterius.biomancy.util.permission.IRestrictedInteraction;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class OwnableDoorBlock
extends DoorBlock
implements OwnableEntityBlock {
    public static final int UPDATE_FLAGS = 10;

    public OwnableDoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(properties, type);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? ((BlockEntityType)ModBlockEntities.OWNABLE_BE.get()).m_155264_(pos, state) : ((BlockEntityType)ModBlockEntities.BE_DELEGATOR.get()).m_155264_(pos, state);
    }

    public boolean isInteractionAllowed(BlockState state, Level level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = this.getCorrectBlockEntity(state, (BlockGetter)level, pos);
        if (blockEntity instanceof IRestrictedInteraction) {
            IRestrictedInteraction restricted = (IRestrictedInteraction)blockEntity;
            if (entity == null) {
                return false;
            }
            return restricted.isActionAllowed(entity, Actions.USE_BLOCK);
        }
        return true;
    }

    @Nullable
    public BlockEntity getCorrectBlockEntity(BlockState state, BlockGetter level, BlockPos posIn) {
        BlockPos mainPos = state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? posIn.m_7495_() : posIn;
        BlockEntity blockEntity = level.m_7702_(mainPos);
        if (blockEntity instanceof IBlockEntityDelegator) {
            IBlockEntityDelegator delegator = (IBlockEntityDelegator)blockEntity;
            return delegator.getDelegate();
        }
        return blockEntity;
    }

    public boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_52729_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = this.getCorrectBlockEntity(state, (BlockGetter)level, pos);
        if (!(blockEntity instanceof IRestrictedInteraction)) {
            return InteractionResult.PASS;
        }
        IRestrictedInteraction restrictedBlock = (IRestrictedInteraction)blockEntity;
        if (!restrictedBlock.isActionAllowed(player, Actions.USE_BLOCK)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof EssenceItem) {
            EssenceItem essenceItem = (EssenceItem)item;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (restrictedBlock.isActionAllowed(player, Actions.CONFIGURE)) {
                boolean success = essenceItem.getEntityUUID(stack).map(restrictedBlock::addUser).orElse(false);
                if (success) {
                    stack.m_41774_(1);
                    level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                    return InteractionResult.SUCCESS;
                }
            }
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            return InteractionResult.CONSUME;
        }
        state = (BlockState)state.m_61122_((Property)f_52727_);
        level.m_7731_(pos, state, 10);
        boolean isOpen = this.m_52815_(state);
        this.playSound(player, level, pos, isOpen);
        boolean isRightHingeSide = state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT;
        Direction direction = (Direction)state.m_61143_((Property)f_52726_);
        BlockPos connectedPos = switch (direction) {
            case Direction.SOUTH -> pos.m_121945_(isRightHingeSide ? Direction.EAST : Direction.WEST);
            case Direction.WEST -> pos.m_121945_(isRightHingeSide ? Direction.SOUTH : Direction.NORTH);
            case Direction.NORTH -> pos.m_121945_(isRightHingeSide ? Direction.WEST : Direction.EAST);
            default -> pos.m_121945_(isRightHingeSide ? Direction.NORTH : Direction.SOUTH);
        };
        BlockState connectedState = level.m_8055_(connectedPos);
        if (connectedState.m_60713_((Block)this) && connectedState.m_61143_((Property)f_52726_) == direction && connectedState.m_61143_((Property)f_52728_) != state.m_61143_((Property)f_52728_) && this.isInteractionAllowed(connectedState, level, connectedPos, (Entity)player) && this.m_52815_(connectedState) != isOpen) {
            connectedState = (BlockState)connectedState.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(isOpen));
            level.m_7731_(connectedPos, connectedState, 10);
            this.playSound(player, level, connectedPos, isOpen);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_153165_(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && open != this.m_52815_(state)) {
            if (!this.isInteractionAllowed(state, level, pos, entity)) {
                return;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(null, level, pos, open);
            level.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (neighborBlock == this) {
            return;
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        BlockEntity blockEntity = this.getCorrectBlockEntity(state, (BlockGetter)level, pos);
        if (blockEntity instanceof IRestrictedInteraction) {
            boolean hasSignal;
            Ownable neighbor;
            Optional<UUID> neighborOwner;
            BlockEntity blockEntity2;
            IRestrictedInteraction restricted = (IRestrictedInteraction)blockEntity;
            boolean isAllowed = false;
            if (neighborBlock instanceof OwnableEntityBlock && level.m_8055_(neighborPos).m_60713_(neighborBlock) && (blockEntity2 = level.m_7702_(neighborPos)) instanceof Ownable && (neighborOwner = (neighbor = (Ownable)blockEntity2).getOptionalOwnerUUID()).isPresent()) {
                isAllowed = restricted.isActionAllowed(neighborOwner.get(), Actions.USE_BLOCK);
            }
            boolean bl = level.m_276867_(pos) || level.m_276867_(pos.m_121945_(half == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (hasSignal = false);
            if (isAllowed) {
                this.handleAllowedSignal(state, level, pos, hasSignal);
                return;
            }
            this.handleForbiddenSignal(state, level, pos, hasSignal, this.isPowered(state));
        }
    }

    private void handleForbiddenSignal(BlockState state, Level level, BlockPos posIn, boolean hasSignal, boolean isPowered) {
        if (hasSignal == isPowered) {
            return;
        }
        if (this.m_52815_(state)) {
            this.playSound(null, level, posIn, false);
            state = (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false));
            level.m_142346_(null, GameEvent.f_157793_, posIn);
        } else if (hasSignal) {
            level.m_5594_(null, posIn, SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_7731_(posIn, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasSignal)), 2);
    }

    private void handleAllowedSignal(BlockState state, Level level, BlockPos pos, boolean hasSignal) {
        if (hasSignal == this.m_52815_(state)) {
            return;
        }
        this.playSound(null, level, pos, hasSignal);
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasSignal))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(hasSignal)), 2);
        level.m_142346_(null, hasSignal ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        if (facing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            if (facingState.m_60713_((Block)this) && facingState.m_61143_((Property)f_52730_) != half) {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_52726_, (Comparable)((Direction)facingState.m_61143_((Property)f_52726_)))).m_61124_((Property)f_52727_, (Comparable)((Boolean)facingState.m_61143_((Property)f_52727_)))).m_61124_((Property)f_52728_, (Comparable)((DoorHingeSide)facingState.m_61143_((Property)f_52728_)))).m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(this.isPowered(facingState)));
            }
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    protected void playSound(@Nullable Player player, Level level, BlockPos pos, boolean isOpening) {
        level.m_5594_(player, pos, isOpening ? this.m_278711_().f_271258_() : this.m_278711_().f_271425_(), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        OwnableEntityBlock.appendUserListToTooltip(stack, tooltip);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Ownable) {
            Ownable ownable = (Ownable)blockEntity;
            OwnableEntityBlock.setBlockEntityOwner(level, ownable, placer, stack);
        }
        if (blockEntity instanceof IBlockEntityDelegator) {
            IBlockEntityDelegator delegator = (IBlockEntityDelegator)blockEntity;
            BlockEntity blockEntity2 = level.m_7702_(pos.m_7495_());
            if (blockEntity2 instanceof OwnableBlockEntity) {
                OwnableBlockEntity ownable = (OwnableBlockEntity)blockEntity2;
                delegator.setDelegate(ownable);
            }
        }
    }

    public void m_5707_(Level level, BlockPos posIn, BlockState state, Player player) {
        super.m_5707_(level, posIn, state, player);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        IRestrictedInteraction interaction;
        BlockEntity blockEntity = this.getCorrectBlockEntity(state, level, pos);
        if (blockEntity instanceof IRestrictedInteraction && (interaction = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.DESTROY_BLOCK)) {
            return super.m_5880_(state, player, level, pos);
        }
        return 0.0f;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }
}

