/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.ownable;

import com.github.elenterius.biomancy.block.property.UserSensitivity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModBlockProperties;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.util.ownable.Ownable;
import com.github.elenterius.biomancy.util.ownable.OwnableEntityBlock;
import com.github.elenterius.biomancy.util.permission.Actions;
import com.github.elenterius.biomancy.util.permission.IRestrictedInteraction;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class OwnablePressurePlateBlock
extends PressurePlateBlock
implements OwnableEntityBlock {
    public static final EnumProperty<UserSensitivity> USER_SENSITIVITY = ModBlockProperties.USER_SENSITIVITY;
    public static final Predicate<Entity> ENTITY_SELECTOR = entity -> !entity.m_5833_() && !entity.m_6090_();

    public OwnablePressurePlateBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(PressurePlateBlock.Sensitivity.MOBS, properties, type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(USER_SENSITIVITY, (Comparable)((Object)UserSensitivity.FRIENDLY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{USER_SENSITIVITY});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.OWNABLE_BE.get()).m_155264_(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Ownable) {
            Ownable ownable = (Ownable)blockEntity;
            OwnableEntityBlock.setBlockEntityOwner(level, ownable, placer, stack);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IRestrictedInteraction restrictedBlock;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (restrictedBlock = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.USE_BLOCK)) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (item instanceof EssenceItem) {
                EssenceItem essenceItem = (EssenceItem)item;
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (restrictedBlock.isActionAllowed(player, Actions.CONFIGURE)) {
                    boolean success = essenceItem.getEntityUUID(stack).map(restrictedBlock::addUser).orElse(false);
                    if (success) {
                        stack.m_41774_(1);
                        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                        return InteractionResult.SUCCESS;
                    }
                }
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                return InteractionResult.CONSUME;
            }
            if (player.m_6144_()) {
                state = (BlockState)state.m_61124_(USER_SENSITIVITY, (Comparable)((Object)((UserSensitivity)((Object)state.m_61143_(USER_SENSITIVITY))).cycle()));
                level.m_7731_(pos, state, 2);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    protected int m_6693_(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction) {
            IRestrictedInteraction interaction = (IRestrictedInteraction)blockEntity;
            List list = level.m_6443_(LivingEntity.class, f_49287_.m_82338_(pos), ENTITY_SELECTOR);
            if (!list.isEmpty()) {
                BlockState state = level.m_8055_(pos);
                UserSensitivity sensitivity = (UserSensitivity)((Object)state.m_61143_(USER_SENSITIVITY));
                if (sensitivity == UserSensitivity.HOSTILE) {
                    for (Entity entity : list) {
                        if (interaction.isActionAllowed(entity.m_20148_(), Actions.USE_BLOCK)) continue;
                        return 15;
                    }
                    return 0;
                }
                if (sensitivity == UserSensitivity.FRIENDLY) {
                    for (Entity entity : list) {
                        if (!interaction.isActionAllowed(entity.m_20148_(), Actions.USE_BLOCK)) continue;
                        return 15;
                    }
                }
            }
        }
        return 0;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        IRestrictedInteraction interaction;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (interaction = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.DESTROY_BLOCK)) {
            return super.m_5880_(state, player, level, pos);
        }
        return 0.0f;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter pLevel, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, pLevel, tooltip, flag);
        OwnableEntityBlock.appendUserListToTooltip(stack, tooltip);
    }
}

